/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.listener")
public class CreateHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttpListener.class);
    @Param(name="listeneraddress")
    String listenerAddress;
    @Param(name="listenerport")
    String listenerPort;
    @Param(name="defaultvs")
    String defaultVirtualServer;
    @Param(name="servername", optional=true)
    String serverName;
    @Param(name="acceptorthreads", optional=true)
    String acceptorThreads;
    @Param(name="xpowered", optional=true, defaultValue="true")
    Boolean xPoweredBy;
    @Param(name="redirectport", optional=true)
    String redirectPort;
    @Param(name="externalport", optional=true)
    String externalPort;
    @Param(name="securityenabled", optional=true, defaultValue="false")
    Boolean securityEnabled;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true, defaultValue="false")
    Boolean secure;
    @Param(name="family", optional=true)
    String family;
    @Param(name="blockingenabled", optional=true, defaultValue="false")
    Boolean blockingEnabled;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(name="listener_id", primary=true)
    String listenerId;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        HttpService httpService = config.getHttpService();
        for (HttpListener listener : httpService.getHttpListener()) {
            if (!listener.getId().equals(this.listenerId)) continue;
            report.setMessage(localStrings.getLocalString("create.http.listener.duplicate", "Http Listener named {0} already exists.", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HttpService>(){

                public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
                    HttpListener newListener = (HttpListener)ConfigSupport.createChildOf((Object)param, HttpListener.class);
                    newListener.setId(CreateHttpListener.this.listenerId);
                    newListener.setAddress(CreateHttpListener.this.listenerAddress);
                    newListener.setPort(CreateHttpListener.this.listenerPort);
                    newListener.setExternalPort(CreateHttpListener.this.externalPort);
                    newListener.setAcceptorThreads(CreateHttpListener.this.acceptorThreads);
                    newListener.setSecurityEnabled(CreateHttpListener.this.securityEnabled.toString());
                    newListener.setDefaultVirtualServer(CreateHttpListener.this.defaultVirtualServer);
                    newListener.setXpoweredBy(CreateHttpListener.this.xPoweredBy.toString());
                    newListener.setEnabled(CreateHttpListener.this.enabled.toString());
                    newListener.setServerName(CreateHttpListener.this.serverName);
                    newListener.setFamily(CreateHttpListener.this.family);
                    newListener.setBlockingEnabled(CreateHttpListener.this.blockingEnabled.toString());
                    if (CreateHttpListener.this.properties != null) {
                        for (Map.Entry<Object, Object> entry : CreateHttpListener.this.properties.entrySet()) {
                            Property property = (Property)ConfigSupport.createChildOf((Object)newListener, Property.class);
                            property.setName((String)entry.getKey());
                            property.setValue((String)entry.getValue());
                            newListener.getProperty().add(property);
                        }
                    }
                    param.getHttpListener().add(newListener);
                    return newListener;
                }
            }, (ConfigBeanProxy)httpService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.http.listener.fail", "{0} create failed ", new Object[]{this.listenerId}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

