/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-http-listener")
@Scoped(value=PerLookup.class)
@I18n(value="delete.http.listener")
public class DeleteHttpListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteHttpListener.class);
    @Param(name="listener_id", primary=true)
    String lid;
    @Param(name="secure", optional=true)
    String secure;
    @Inject
    HttpService httpService;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.exists()) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.notexists", "{0} doesn't exist", new Object[]{this.lid}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new Config(this.lid), (ConfigBeanProxy)this.httpService);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.http.listener.fail", "failed", new Object[]{this.lid}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private boolean exists() {
        if (this.lid == null) {
            return false;
        }
        List list = this.httpService.getHttpListener();
        for (HttpListener hl : list) {
            String currId = hl.getId();
            if (currId == null || !currId.equals(this.lid)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Config
    implements SingleConfigCode<HttpService> {
        private String lid;

        private Config(String lid) {
            this.lid = lid;
        }

        public Object run(HttpService param) throws PropertyVetoException, TransactionFailure {
            List list = param.getHttpListener();
            for (HttpListener listener : list) {
                String currId = listener.getId();
                if (currId == null || !currId.equals(this.lid)) continue;
                list.remove(listener);
                break;
            }
            return list;
        }
    }
}

