/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup;

import com.sun.enterprise.backup.BackupRequest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoggerHelper {
    private static Logger logger = null;

    private LoggerHelper() {
    }

    static final Logger get() {
        return logger;
    }

    static final void setLevel(BackupRequest req) {
        if (req.terse) {
            logger.setLevel(Level.WARNING);
        } else if (req.verbose) {
            logger.setLevel(Level.FINEST);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    static final void finest(String s) {
        logger.finest(s);
    }

    static final void finest(String s, Object o) {
        logger.log(Level.FINEST, s, new Object[]{o});
    }

    static final void finer(String s) {
        logger.finer(s);
    }

    static final void finer(String s, Object o) {
        logger.log(Level.FINER, s, new Object[]{o});
    }

    static final void fine(String s) {
        logger.fine(s);
    }

    static final void fine(String s, Object o) {
        logger.log(Level.FINE, s, new Object[]{o});
    }

    static final void info(String s) {
        logger.info(s);
    }

    static final void info(String s, Object o) {
        logger.log(Level.INFO, s, new Object[]{o});
    }

    static final void warning(String s) {
        logger.warning(s);
    }

    static final void warning(String s, Object o) {
        logger.log(Level.WARNING, s, new Object[]{o});
    }

    static final void severe(String s) {
        logger.severe(s);
    }

    static final void severe(String s, Object o) {
        logger.log(Level.SEVERE, s, new Object[]{o});
    }

    static {
        try {
            logger = Logger.getLogger("backup", "com.sun.enterprise.backup.LocalStrings");
            ConsoleHandler h = new ConsoleHandler();
            h.setLevel(Level.FINEST);
            logger.addHandler(h);
        }
        catch (Throwable t) {
            try {
                logger = Logger.getLogger("backup");
                logger.warning("Couldn't create Backup Logger with a resource bundle.  Created a Logger without a Resource Bundle.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

