/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.backup.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FileLister {
    private ArrayList fileList = null;
    private File mainRoot = null;
    private boolean keepEmpty = false;

    protected abstract boolean relativePath();

    FileLister(File root) {
        this.mainRoot = root;
        this.fileList = new ArrayList();
    }

    public void keepEmptyDirectories() {
        this.keepEmpty = true;
    }

    public String[] getFiles() {
        this.getFilesInternal(this.mainRoot);
        String[] files = new String[this.fileList.size()];
        if (files.length <= 0) {
            return files;
        }
        int len = 0;
        if (this.relativePath()) {
            len = this.mainRoot.getPath().length() + 1;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = ((File)this.fileList.get(i)).getPath().substring(len).replace('\\', '/');
        }
        Arrays.sort(files, String.CASE_INSENSITIVE_ORDER);
        return files;
    }

    private void getFilesInternal(File root) {
        File[] files = root.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getFilesInternal(files[i]);
                continue;
            }
            this.fileList.add(files[i]);
        }
        if (files.length <= 0 && this.keepEmpty) {
            this.fileList.add(root);
        }
    }
}

