/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CLILogger {
    private static boolean debug;
    private static CLILogger logger;
    private Logger s1asLogger;
    private static final String DEBUG_FLAG = "Debug";
    private static final String ENV_DEBUG_FLAG = "AS_DEBUG";
    private static final int kDefaultBufferSize = 512;
    private static final String PACKAGE_NAME = "com.sun.enterprise.cli.framework";
    private static boolean allowOutputLevelChanges;
    private static Level pushedLevel;

    protected CLILogger() {
        String sys = System.getProperty(DEBUG_FLAG);
        boolean env = Boolean.parseBoolean(System.getenv(ENV_DEBUG_FLAG));
        debug = sys != null || env;
        this.s1asLogger = Logger.getLogger(PACKAGE_NAME, null);
        if (CLILogger.isDebug()) {
            this.s1asLogger.setLevel(Level.FINEST);
        } else {
            this.s1asLogger.setLevel(Level.INFO);
        }
        this.s1asLogger.addHandler(new CLILoggerHandler());
        this.s1asLogger.setUseParentHandlers(false);
    }

    public static boolean isDebug() {
        return debug;
    }

    public static synchronized CLILogger getInstance() {
        if (logger == null) {
            logger = new CLILogger();
        }
        return logger;
    }

    public void pushAndLockLevel(Level newLevel) {
        pushedLevel = this.getOutputLevel();
        this.setOutputLevel(newLevel);
        allowOutputLevelChanges = false;
    }

    public void popAndUnlockLevel() {
        allowOutputLevelChanges = true;
        this.setOutputLevel(pushedLevel);
    }

    public Level getOutputLevel() {
        return this.s1asLogger.getLevel();
    }

    public void setOutputLevel(Level level) {
        if (!CLILogger.isDebug() && allowOutputLevelChanges) {
            this.s1asLogger.setLevel(level);
        }
    }

    public void printMessage(String message) {
        this.s1asLogger.log(Level.INFO, message);
    }

    public void printDetailMessage(String message) {
        this.s1asLogger.log(Level.FINE, message);
    }

    public void printWarning(String message) {
        this.s1asLogger.log(Level.WARNING, message);
    }

    public void printError(String message) {
        this.s1asLogger.log(Level.SEVERE, message);
    }

    public void printDebugMessage(String message) {
        this.s1asLogger.log(Level.FINEST, message);
    }

    public void printExceptionStackTrace(Throwable e) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(512);
        e.printStackTrace(new PrintStream(output));
        this.printDebugMessage(output.toString());
    }

    public static void main(String[] args) {
        CLILogger logger = new CLILogger();
        try {
            String sLevel = null;
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            InputsAndOutputs.getInstance().getUserOutput().print(lsm.getString("PROMPT"));
            sLevel = InputsAndOutputs.getInstance().getUserInput().getLine();
            logger.setOutputLevel(Level.parse(sLevel));
            System.out.println("Logger level = " + logger.getOutputLevel());
            logger.printDetailMessage("Fine");
            logger.printMessage("Info");
            logger.printError("Error");
            logger.printWarning("Warning");
            logger.printDebugMessage(DEBUG_FLAG);
            InputsAndOutputs.getInstance().setUserOutputFile("UserOutput.txt");
            InputsAndOutputs.getInstance().setErrorOutputFile("ErrorOutput.txt");
            InputsAndOutputs.getInstance().setUserInputFile("test_input.txt");
            InputsAndOutputs.getInstance().getUserOutput().print(lsm.getString("PROMPT"));
            sLevel = InputsAndOutputs.getInstance().getUserInput().getLine();
            logger.setOutputLevel(Level.parse(sLevel));
            logger.printDetailMessage("Fine");
            logger.printMessage("Info");
            logger.printError("Error");
            logger.printWarning("Warning");
            logger.printDebugMessage(DEBUG_FLAG);
        }
        catch (Exception e) {
            logger.printExceptionStackTrace(e);
        }
    }

    static {
        allowOutputLevelChanges = true;
    }

    public class CLILoggerHandler
    extends Handler {
        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel() == Level.SEVERE) {
                InputsAndOutputs.getInstance().getErrorOutput().println(logRecord.getMessage());
            } else {
                InputsAndOutputs.getInstance().getUserOutput().println(logRecord.getMessage());
            }
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }
    }
}

