/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="file")
@Scoped(value=PerLookup.class)
public class FileArchive
implements ReadableArchive,
WritableArchive {
    @Inject
    ArchiveFactory archiveFactory;
    File archive;
    URI uri;
    OutputStream os = null;

    public void open(URI uri) throws IOException {
        if (!uri.getScheme().equals("file")) {
            throw new IOException("Wrong scheme for FileArchive : " + uri.getScheme());
        }
        this.uri = uri;
        this.archive = new File(uri);
        if (!this.archive.exists()) {
            throw new FileNotFoundException(uri.getSchemeSpecificPart());
        }
    }

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        File tmpFile = new File(this.uri);
        return tmpFile.length();
    }

    public void create(URI uri) throws IOException {
        this.uri = uri;
        this.archive = new File(uri);
        this.archive.mkdirs();
    }

    public void closeEntry(WritableArchive subArchive) throws IOException {
        subArchive.close();
    }

    public void close() throws IOException {
    }

    public boolean delete() {
        try {
            return this.deleteDir(this.archive);
        }
        catch (IOException e) {
            return false;
        }
    }

    public Enumeration entries() {
        Vector namesList = new Vector();
        this.getListOfFiles(this.archive, namesList, null);
        return namesList.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        Vector nameList = new Vector();
        ArrayList<String> massagedNames = new ArrayList<String>();
        while (embeddedArchives.hasMoreElements()) {
            String subArchiveName = (String)embeddedArchives.nextElement();
            massagedNames.add(FileUtils.makeFriendlyFilename(subArchiveName));
        }
        this.getListOfFiles(this.archive, nameList, massagedNames);
        return nameList.elements();
    }

    public Enumeration entries(String prefix) {
        prefix = prefix.replace('/', File.separatorChar);
        File file = new File(this.archive, prefix);
        Vector namesList = new Vector();
        this.getListOfFiles(file, namesList, null);
        return namesList.elements();
    }

    public boolean exists() {
        return this.archive.exists();
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        String subEntryName = this.getFileSubArchivePath(name);
        File subEntry = new File(subEntryName);
        if (subEntry.exists()) {
            return this.archiveFactory.openArchive(subEntry);
        }
        return null;
    }

    public WritableArchive createSubArchive(String name) throws IOException {
        String subEntryName = this.getFileSubArchivePath(name);
        File subEntry = new File(subEntryName);
        if (!subEntry.exists()) {
            subEntry.mkdirs();
            return this.archiveFactory.createArchive(subEntry);
        }
        return null;
    }

    private String getFileSubArchivePath(String name) throws IOException {
        File subDir;
        File file = new File(name = name.replace('/', File.separatorChar));
        if (file.isAbsolute()) {
            subDir = file;
        } else {
            subDir = new File(this.archive, FileUtils.makeFriendlyFilename(name));
            if (!subDir.exists() && !(subDir = new File(this.archive, name)).exists()) {
                subDir = new File(this.archive, FileUtils.makeFriendlyFilename(name));
            }
        }
        return subDir.getPath();
    }

    public boolean exists(String name) throws IOException {
        name = name.replace('/', File.separatorChar);
        File input = new File(this.archive, name);
        return input.exists();
    }

    public InputStream getEntry(String name) throws IOException {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(input);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            return bis;
        }
        catch (Throwable tx) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable thr) {
                    IOException ioe = new IOException("Error closing FileInputStream after error opening BufferedInputStream for entry " + name);
                    ioe.initCause(thr);
                    throw ioe;
                }
            }
            IOException ioe = new IOException("Error opening BufferedInputStream for entry " + name);
            ioe.initCause(tx);
            throw ioe;
        }
    }

    public long getEntrySize(String name) {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists()) {
            return 0L;
        }
        return input.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        InputStream is = null;
        try {
            is = this.getEntry("META-INF/MANIFEST.MF");
            if (is != null) {
                Manifest m;
                Manifest manifest = m = new Manifest(is);
                return manifest;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean renameTo(String name) {
        return FileUtils.renameFile(this.archive, new File(name));
    }

    private boolean deleteDir(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new FileNotFoundException(directory.getPath());
        }
        File[] entries = directory.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].isDirectory()) {
                this.deleteDir(entries[i]);
                continue;
            }
            FileUtils.deleteFile(entries[i]);
        }
        return FileUtils.deleteFile(directory);
    }

    private void getListOfFiles(File directory, Vector files, List embeddedArchives) {
        File[] list = directory.listFiles();
        for (int i = 0; i < list.length; ++i) {
            String fileName = list[i].getAbsolutePath().substring(this.archive.getAbsolutePath().length() + 1);
            if (!list[i].isDirectory()) {
                if ((fileName = fileName.replace(File.separatorChar, '/')).equals("META-INF/MANIFEST.MF")) continue;
                files.add(fileName);
                continue;
            }
            if (embeddedArchives != null) {
                if (embeddedArchives.contains(fileName)) continue;
                this.getListOfFiles(list[i], files, null);
                continue;
            }
            this.getListOfFiles(list[i], files, null);
        }
    }

    public boolean supportsElementsOverwriting() {
        return true;
    }

    public boolean deleteEntry(String name) {
        File input = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (!input.exists()) {
            return false;
        }
        return input.delete();
    }

    public void closeEntry() throws IOException {
        if (this.os != null) {
            this.os.flush();
            this.os.close();
            this.os = null;
        }
    }

    public OutputStream putNextEntry(String name) throws IOException {
        File newFile = new File(this.archive, name = name.replace('/', File.separatorChar));
        if (newFile.exists() && !this.deleteEntry(name)) {
            throw new IOException(name + " already exists and cannot be deleted");
        }
        if (name.lastIndexOf(File.separatorChar) != -1) {
            String dirs = name.substring(0, name.lastIndexOf(File.separatorChar));
            new File(this.archive, dirs).mkdirs();
        }
        this.os = new BufferedOutputStream(new FileOutputStream(newFile));
        return this.os;
    }

    public String getName() {
        return Util.getURIName(this.getURI());
    }
}

