/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.util.Environment;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public final class Utility {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Utility.class);

    public static void checkJVMVersion() {
    }

    public static Properties getPropertiesFromFile(String file) throws IOException {
        InputStream is = ClassLoader.getSystemResourceAsStream(file);
        if (is != null) {
            Properties config = new Properties();
            config.load(is);
            return config;
        }
        String remoteclient = "/" + file;
        InputStream is2 = Utility.class.getResourceAsStream(remoteclient);
        Properties config = new Properties();
        config.load(is2);
        return config;
    }

    public static String getLocalHost() {
        String hostname = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostname = ia.getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
        return hostname;
    }

    public static String getLocalAddress() {
        String address = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            address = ia.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
        return address;
    }

    public static Remote lookupObject(String publishedName, Class anInterface) throws NamingException {
        InitialContext ic = new InitialContext();
        Object objRef = ic.lookup(publishedName);
        return (Remote)PortableRemoteObject.narrow((Object)objRef, (Class)anInterface);
    }

    public static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset++] << 24 & 0xFF000000;
        int b2 = array[offset++] << 16 & 0xFF0000;
        int b3 = array[offset++] << 8 & 0xFF00;
        int b4 = array[offset++] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    public static void intToBytes(int value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 24 & 0xFF);
        array[offset++] = (byte)(value >>> 16 & 0xFF);
        array[offset++] = (byte)(value >>> 8 & 0xFF);
        array[offset++] = (byte)(value >>> 0 & 0xFF);
    }

    public static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)Utility.bytesToInt(array, offset) << 32;
        long l2 = (long)Utility.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    public static void longToBytes(long value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 56 & 0xFFL);
        array[offset++] = (byte)(value >>> 48 & 0xFFL);
        array[offset++] = (byte)(value >>> 40 & 0xFFL);
        array[offset++] = (byte)(value >>> 32 & 0xFFL);
        array[offset++] = (byte)(value >>> 24 & 0xFFL);
        array[offset++] = (byte)(value >>> 16 & 0xFFL);
        array[offset++] = (byte)(value >>> 8 & 0xFFL);
        array[offset++] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void invokeApplicationMain(Class mainClass, String[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String err = localStrings.getLocalString("utility.no.main", "", mainClass);
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException msme) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_in_utility", msme);
            throw new ClassNotFoundException(err);
        }
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            err = localStrings.getLocalString("utility.main.notpublicorstatic", "The main method is either not public or not static");
            _logger.log(Level.SEVERE, "enterprise_util.excep_in_utility_main.notpublicorstatic");
            throw new ClassNotFoundException(err);
        }
        if (!mainMethod.getReturnType().equals(Void.TYPE)) {
            err = localStrings.getLocalString("utility.main.notvoid", "The main method's return type is not void ");
            _logger.log(Level.SEVERE, "enterprise_util.excep_in_utility_main.notvoid");
            throw new ClassNotFoundException(err);
        }
        Object[] params = new Object[]{args};
        mainMethod.invoke(null, params);
    }

    public static void invokeSetMethod(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cl = obj.getClass();
        String setMeth = "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        try {
            Class[] cldef = new Class[]{String.class};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = new Object[]{value};
            meth.invoke(obj, params);
            return;
        }
        catch (NoSuchMethodException ex) {
            try {
                Class[] cldef = new Class[]{Integer.TYPE};
                Method meth = cl.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Integer.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
            catch (NoSuchMethodException nsmex) {
                Class[] cldef = new Class[]{Boolean.TYPE};
                Method meth = cl.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Boolean.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
        }
    }

    public static void invokeSetMethodCaseInsensitive(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String alternateMethodName = null;
        Class<?> cl = obj.getClass();
        String setMeth = "set" + prop;
        Method[] methodsList = cl.getMethods();
        boolean methodFound = false;
        int i = 0;
        for (i = 0; i < methodsList.length; ++i) {
            Class<?>[] parameterTypes;
            if (!methodsList[i].getName().equalsIgnoreCase(setMeth) || (parameterTypes = methodsList[i].getParameterTypes()).length != 1) continue;
            if (parameterTypes[0].getName().equals("java.lang.String")) {
                methodFound = true;
                break;
            }
            alternateMethodName = methodsList[i].getName();
        }
        if (methodFound) {
            Object[] params = new Object[]{value};
            methodsList[i].invoke(obj, params);
            return;
        }
        if (alternateMethodName != null) {
            try {
                Class[] cldef = new Class[]{Integer.TYPE};
                Method meth = cl.getMethod(alternateMethodName, cldef);
                Object[] params = new Object[]{Integer.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
            catch (NoSuchMethodException nsmex) {
                Class[] cldef = new Class[]{Boolean.TYPE};
                Method meth = cl.getMethod(alternateMethodName, cldef);
                Object[] params = new Object[]{Boolean.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
        }
        throw new NoSuchMethodException(setMeth);
    }

    public static short intToShort(int value) {
        if (value > Short.MAX_VALUE) {
            return (short)(value - 65536);
        }
        return (short)value;
    }

    public static int shortToInt(short value) {
        if (value < 0) {
            return value + 65536;
        }
        return value;
    }

    public static ClassLoader getClassLoader() {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return Utility.getClassLoader().loadClass(className);
    }

    public static ClassLoader setContextClassLoader(ClassLoader newClassLoader) {
        final ClassLoader classLoaderToSet = newClassLoader;
        final Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToSet != originalClassLoader) {
            if (System.getSecurityManager() == null) {
                currentThread.setContextClassLoader(classLoaderToSet);
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        currentThread.setContextClassLoader(classLoaderToSet);
                        return null;
                    }
                });
            }
        }
        return originalClassLoader;
    }

    public static void setEnvironment() {
        Environment.obtain().activateEnvironment();
    }
}

