/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.deployment.archive.ReadableArchive;

public class DeploymentUtils {
    private static final String WEB_XML = "WEB-INF/web.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_LIB = "WEB-INF/lib";

    public static boolean isWebArchive(ReadableArchive archive) {
        try {
            return archive.exists(WEB_XML) || archive.exists(WEB_INF_CLASSES) || archive.exists(WEB_INF_LIB);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory(new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName(moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilename(moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }
}

