/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.spi.ConnectorConstants;
import com.sun.appserv.connectors.spi.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.container.common.spi.JavaEETransaction;
import com.sun.enterprise.container.common.spi.JavaEETransactionManager;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.AbstractPoolManager;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.ResourcePoolFactoryImpl;
import com.sun.enterprise.resource.rm.NoTxResourceManagerImpl;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.resource.rm.ResourceManagerImpl;
import com.sun.enterprise.resource.rm.SystemResourceManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.jvnet.hk2.annotations.Service;

@Service
public class PoolManagerImpl
extends AbstractPoolManager {
    private ConcurrentHashMap<String, ResourcePool> poolTable = new ConcurrentHashMap();
    private ResourceManager resourceManager = new ResourceManagerImpl();
    private ResourceManager sysResourceManager = new SystemResourceManagerImpl();
    private ResourceManager noTxResourceManager = new NoTxResourceManagerImpl();
    private static Logger _logger = null;

    public void createEmptyConnectionPool(String poolName, ConnectorConstants.PoolType pt) throws PoolingException {
        this.createAndInitPool(poolName, pt);
    }

    private ResourcePool createAndInitPool(String poolName, ConnectorConstants.PoolType pt) throws PoolingException {
        ResourcePool pool = this.getPool(poolName);
        if (pool == null) {
            pool = ResourcePoolFactoryImpl.newInstance(poolName, pt);
            this.addPool(pool);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Created connection  pool  and added it to PoolManager :" + pool);
            }
        }
        return pool;
    }

    public Object getResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) throws PoolingException {
        Transaction tran = null;
        boolean transactional = alloc.isTransactional();
        if (transactional) {
            tran = this.getResourceManager(spec).getTransaction();
        }
        ResourceHandle handle = this.getResourceFromPool(spec, alloc, info, tran);
        handle.setResourceSpec(spec);
        try {
            if (handle.getResourceState().isUnenlisted()) {
                this.getResourceManager(spec).enlistResource(handle);
            }
        }
        catch (Exception e) {
            this.putbackDirectToPool(handle, spec.getConnectionPoolName());
            _logger.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn");
            this.logFine("rm.enlistResource threw Exception. Returning resource to pool");
            throw new PoolingException(e);
        }
        return handle.getUserConnection();
    }

    public void putbackDirectToPool(ResourceHandle h, String poolName) {
        ResourcePool pool;
        if (poolName != null && (pool = this.poolTable.get(poolName)) != null) {
            pool.resourceClosed(h);
        }
    }

    public ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Transaction tran) throws PoolingException {
        ResourcePool pool = this.getPool(spec.getConnectionPoolName());
        return pool.getResource(spec, alloc, tran);
    }

    public boolean switchOnMatching(String poolName) {
        ResourcePool pool = (ResourcePool)this.getPoolTable().get(poolName);
        if (pool != null) {
            pool.switchOnMatching();
            return true;
        }
        return false;
    }

    public ConcurrentHashMap getPoolTable() {
        return this.poolTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPool(ResourcePool pool) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Adding pool " + pool.getPoolName() + "to pooltable");
        }
        ConcurrentHashMap<String, ResourcePool> concurrentHashMap = this.poolTable;
        synchronized (concurrentHashMap) {
            this.poolTable.put(pool.getPoolName(), pool);
        }
    }

    private ResourceManager getResourceManager(ResourceSpec spec) {
        if (spec.isNonTx()) {
            this.logFine("Returning noTxResourceManager");
            return this.noTxResourceManager;
        }
        if (spec.isPM()) {
            this.logFine("Returning sysResourceManager");
            return this.sysResourceManager;
        }
        this.logFine("Returning resourceManager");
        return this.resourceManager;
    }

    private void addSyncListener(Transaction tran) {
        SynchronizationListener sync = new SynchronizationListener(tran);
        try {
            tran.registerSynchronization((Synchronization)sync);
        }
        catch (Exception ex) {
            _logger.fine("Error adding syncListener : " + (ex.getMessage() != null ? ex.getMessage() : " "));
        }
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        Iterator iter = ((JavaEETransaction)tran).getAllParticipatingPools().iterator();
        while (iter.hasNext()) {
            ResourcePool pool = this.getPool((String)iter.next());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("calling transactionCompleted on " + pool.getPoolName());
            }
            pool.transactionCompleted(tran, status);
        }
    }

    public void resourceEnlisted(Transaction tran, com.sun.appserv.connectors.spi.ResourceHandle h) throws IllegalStateException {
        ResourcePool pool;
        ResourceHandle res = (ResourceHandle)h;
        String poolName = res.getResourceSpec().getConnectionPoolName();
        try {
            JavaEETransaction j2eeTran = (JavaEETransaction)tran;
            if (poolName != null && j2eeTran.getResources(poolName) == null) {
                this.addSyncListener(tran);
            }
        }
        catch (ClassCastException e) {
            this.addSyncListener(tran);
        }
        if (poolName != null && (pool = this.getPool(poolName)) != null) {
            pool.resourceEnlisted(tran, res);
        }
    }

    public void postInvoke() throws InvocationException {
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        JavaEETransactionManager tm = runtime.getTransactionManager();
        ComponentInvocation invToUse = runtime.getInvocationManager().getCurrentInvocation();
        if (invToUse == null) {
            return;
        }
        Object comp = invToUse.getInstance();
        if (comp == null) {
            return;
        }
        List list = tm.getExistingResourceList(comp, invToUse);
        if (list == null) {
            return;
        }
    }

    public void registerResource(ResourceHandle handle) throws PoolingException {
        ResourceManager rm = this.getResourceManager(handle.getResourceSpec());
        rm.registerResource(handle);
    }

    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.unregisterResource(resource, xaresFlag);
    }

    public void resourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    public void badResourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackBadResourceToPool(resource);
    }

    public void resourceErrorOccurred(ResourceHandle resource) {
        this.putbackResourceToPool(resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putbackBadResourceToPool(ResourceHandle h) {
        ResourcePool pool;
        try {
            ResourceAllocator alloc = h.getResourceAllocator();
            alloc.cleanup(h);
        }
        catch (PoolingException ex) {
            // empty catch block
        }
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = this.poolTable.get(poolName)) != null) {
            ResourcePool resourcePool = pool;
            synchronized (resourcePool) {
                pool.resourceClosed(h);
                h.setConnectionErrorOccurred();
                pool.resourceErrorOccurred(h);
            }
        }
    }

    public void putbackResourceToPool(ResourceHandle h, boolean errorOccurred) {
        ResourcePool pool;
        try {
            ResourceAllocator alloc = h.getResourceAllocator();
            alloc.cleanup(h);
        }
        catch (PoolingException ex) {
            errorOccurred = true;
        }
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = this.poolTable.get(poolName)) != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(h);
            } else {
                pool.resourceClosed(h);
            }
        }
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public ResourcePool getPool(String name) {
        if (name == null) {
            return null;
        }
        return this.poolTable.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPool(String poolName) {
        ResourcePool pool = this.poolTable.get(poolName);
        if (pool != null) {
            pool.cancelResizerTask();
            pool.emptyPool();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Removing pool " + pool + " from pooltable");
            }
            ConcurrentHashMap<String, ResourcePool> concurrentHashMap = this.poolTable;
            synchronized (concurrentHashMap) {
                this.poolTable.remove(poolName);
            }
        }
    }

    public ResourceReferenceDescriptor getResourceReference(String jndiName) {
        Set descriptors = ConnectorRuntime.getRuntime().getResourceReferenceDescriptor();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)descriptor;
                String name = ref.getJndiName();
                if (!jndiName.equals(name)) continue;
                return ref;
            }
        }
        return null;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction tran) {
            this.tran = tran;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, status);
            }
            catch (Exception ex) {
                _logger.fine("Exception in afterCompletion : " + (ex.getMessage() != null ? ex.getMessage() : " "));
            }
        }

        public void beforeCompletion() {
        }
    }
}

