/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    private static boolean verbose = System.getProperty("servicetag.verbose") != null;
    private static String jrepath = null;
    private static int jdkVersion = 0;
    private static int jdkUpdate = 0;

    Util() {
    }

    static boolean isVerbose() {
        return verbose;
    }

    static synchronized String getJrePath() {
        String javaHome;
        File f;
        if (jrepath == null && !(f = new File(jrepath = (javaHome = System.getProperty("java.home")) + File.separator + "jre", "lib")).exists()) {
            jrepath = javaHome;
        }
        return jrepath;
    }

    static boolean isJdk() {
        return Util.getJrePath().endsWith(File.separator + "jre");
    }

    static String generateURN() {
        return "urn:st:" + UUID.randomUUID().toString();
    }

    static int getIntValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\"" + value + "\"" + " expected to be an integer");
        }
    }

    static String formatTimestamp(Date timestamp) {
        if (timestamp == null) {
            return "[No timestamp]";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(timestamp);
    }

    static Date parseTimestamp(String timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return df.parse(timestamp);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String commandOutput(Process p) throws IOException {
        InputStreamReader r = null;
        Reader err = null;
        try {
            r = new InputStreamReader(p.getInputStream());
            err = new InputStreamReader(p.getErrorStream());
            String output = Util.commandOutput(r);
            String errorMsg = Util.commandOutput(err);
            p.waitFor();
            String string = output + errorMsg.trim();
            return string;
        }
        catch (InterruptedException e) {
            if (Util.isVerbose()) {
                e.printStackTrace();
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
            if (err != null) {
                err.close();
            }
        }
    }

    static String commandOutput(Reader r) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = r.read()) > 0) {
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    static int getJdkVersion() {
        Util.parseVersion();
        return jdkVersion;
    }

    static int getUpdateVersion() {
        Util.parseVersion();
        return jdkUpdate;
    }

    private static synchronized void parseVersion() {
        if (jdkVersion > 0) {
            return;
        }
        String cs = System.getProperty("java.runtime.version");
        if (cs.length() >= 5 && Character.isDigit(cs.charAt(0)) && cs.charAt(1) == '.' && Character.isDigit(cs.charAt(2)) && cs.charAt(3) == '.' && Character.isDigit(cs.charAt(4))) {
            jdkVersion = Character.digit(cs.charAt(2), 10);
            if ((cs = cs.substring(5, cs.length())).charAt(0) == '_' && cs.length() >= 3 && Character.isDigit(cs.charAt(1)) && Character.isDigit(cs.charAt(2))) {
                int nextChar = 3;
                try {
                    String uu = cs.substring(1, 3);
                    jdkUpdate = Integer.valueOf(uu);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
        } else {
            throw new InternalError("Invalid java.runtime.version" + cs);
        }
    }

    private static byte[] stringToByteArray(String str) {
        return (str + "\u0000").getBytes();
    }

    private static String byteArrayToString(byte[] array) {
        return new String(array, 0, array.length - 1);
    }

    static File getWindowsStClientFile() {
        File out = null;
        String regKey = "software\\microsoft\\windows\\currentversion\\app paths\\stclient.exe";
        String keyName = "";
        String path = Util.getRegistryKey(regKey, keyName);
        if (path != null && new File(path).exists()) {
            out = new File(path);
        }
        if (Util.isVerbose()) {
            System.out.println("stclient=" + out);
        }
        return out;
    }

    private static String getRegistryKey(String regKey, String keyName) {
        String out;
        block3: {
            out = null;
            try {
                Class<?> clazz = Class.forName("java.util.prefs.WindowsPreferences");
                Method winRegOpenKeyM = clazz.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                winRegOpenKeyM.setAccessible(true);
                Method winRegCloseKeyM = clazz.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                winRegCloseKeyM.setAccessible(true);
                Method winRegQueryValueM = clazz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                winRegQueryValueM.setAccessible(true);
                int HKLM = Util.getValueFromStaticField("HKEY_LOCAL_MACHINE", clazz);
                int KEY_READ = Util.getValueFromStaticField("KEY_READ", clazz);
                int ERROR_CODE = Util.getValueFromStaticField("ERROR_CODE", clazz);
                int NATIVE_HANDLE = Util.getValueFromStaticField("NATIVE_HANDLE", clazz);
                int ERROR_SUCCESS = Util.getValueFromStaticField("ERROR_SUCCESS", clazz);
                byte[] reg = Util.stringToByteArray(regKey);
                byte[] key = Util.stringToByteArray(keyName);
                int[] result = (int[])winRegOpenKeyM.invoke(null, HKLM, reg, KEY_READ);
                if (result[ERROR_CODE] == ERROR_SUCCESS) {
                    byte[] stvalue = (byte[])winRegQueryValueM.invoke(null, result[NATIVE_HANDLE], key);
                    out = Util.byteArrayToString(stvalue);
                    winRegCloseKeyM.invoke(null, result[NATIVE_HANDLE]);
                }
            }
            catch (Exception ex) {
                if (!Util.isVerbose()) break block3;
                ex.printStackTrace();
            }
        }
        return out;
    }

    private static int getValueFromStaticField(String fldName, Class<?> klass) throws Exception {
        Field f = klass.getDeclaredField(fldName);
        f.setAccessible(true);
        return f.getInt(null);
    }
}

