/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.invocation;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class InvocationManagerImpl
implements InvocationManager,
PostConstruct {
    public static boolean debug;
    private InheritableThreadLocal<InvocationArray<ComponentInvocation>> frames;
    @Inject(optional=true)
    private ComponentInvocationHandler[] handlers = new ComponentInvocationHandler[0];

    public InvocationManagerImpl() {
        this.frames = new InheritableThreadLocal<InvocationArray<ComponentInvocation>>(){

            @Override
            protected InvocationArray initialValue() {
                return new InvocationArray();
            }

            @Override
            protected InvocationArray<ComponentInvocation> childValue(InvocationArray<ComponentInvocation> parentValue) {
                InvocationArray<ComponentInvocation> result = new InvocationArray<ComponentInvocation>();
                InvocationArray<ComponentInvocation> v = parentValue;
                if (v.size() > 0 && v.outsideStartup()) {
                    ComponentInvocation parentInv = (ComponentInvocation)v.get(v.size() - 1);
                    if (parentInv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
                        ComponentInvocation inv = new ComponentInvocation();
                        inv.componentId = null;
                        inv.setComponentInvocationType(parentInv.getInvocationType());
                        inv.instance = null;
                        inv.container = parentInv.getContainerContext();
                        inv.transaction = null;
                        result.add(inv);
                    } else if (parentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                        ComponentInvocation cpy = new ComponentInvocation();
                        cpy.componentId = parentInv.getComponentId();
                        cpy.setComponentInvocationType(parentInv.getInvocationType());
                        cpy.instance = parentInv.getInstance();
                        cpy.container = parentInv.getContainerContext();
                        cpy.transaction = parentInv.getTransaction();
                        result.add(cpy);
                    }
                }
                return result;
            }
        };
    }

    public void postConstruct() {
        if (this.handlers == null) {
            this.handlers = new ComponentInvocationHandler[0];
        }
    }

    @Override
    public <T extends ComponentInvocation> void preInvoke(T inv) throws InvocationException {
        InvocationArray v = (InvocationArray)this.frames.get();
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            v.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP);
            return;
        }
        int beforeSize = v.size();
        ComponentInvocation prevInv = beforeSize > 0 ? (ComponentInvocation)v.get(beforeSize - 1) : null;
        ComponentInvocation.ComponentInvocationType invType = inv.getInvocationType();
        for (ComponentInvocationHandler handler : this.handlers) {
            handler.beforePreInvoke(invType, prevInv, inv);
        }
        v.add(inv);
        for (ComponentInvocationHandler handler : this.handlers) {
            handler.afterPreInvoke(invType, prevInv, inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ComponentInvocation> void postInvoke(T inv) throws InvocationException {
        InvocationArray v = (InvocationArray)this.frames.get();
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            v.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.UN_INITIALIZED);
            return;
        }
        int beforeSize = v.size();
        if (beforeSize == 0) {
            throw new InvocationException();
        }
        ComponentInvocation prevInv = beforeSize > 1 ? (ComponentInvocation)v.get(beforeSize - 2) : null;
        ComponentInvocation curInv = (ComponentInvocation)v.get(beforeSize - 1);
        try {
            ComponentInvocation.ComponentInvocationType invType = inv.getInvocationType();
            for (ComponentInvocationHandler handler : this.handlers) {
                handler.beforePostInvoke(invType, prevInv, curInv);
            }
        }
        finally {
            v.remove(beforeSize - 1);
            for (ComponentInvocationHandler handler : this.handlers) {
                handler.afterPostInvoke(inv.getInvocationType(), prevInv, inv);
            }
        }
    }

    @Override
    public boolean isInvocationStackEmpty() {
        ArrayList v = (ArrayList)this.frames.get();
        return v == null || v.size() == 0;
    }

    @Override
    public <T extends ComponentInvocation> T getCurrentInvocation() {
        ArrayList v = (ArrayList)this.frames.get();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(size - 1));
    }

    @Override
    public <T extends ComponentInvocation> T getPreviousInvocation() throws InvocationException {
        ArrayList v = (ArrayList)this.frames.get();
        int i = v.size();
        if (i < 2) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(i - 2));
    }

    public List getAllInvocations() {
        return (List)this.frames.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InvocationArray<T extends ComponentInvocation>
    extends ArrayList<T> {
        private ComponentInvocation.ComponentInvocationType invocationAttribute;

        InvocationArray() {
        }

        public void setInvocationAttribute(ComponentInvocation.ComponentInvocationType attribute) {
            this.invocationAttribute = attribute;
        }

        public ComponentInvocation.ComponentInvocationType getInvocationAttribute() {
            return this.invocationAttribute;
        }

        public boolean outsideStartup() {
            return this.getInvocationAttribute() != ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP;
        }
    }
}

