/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.rails;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.impl.CookedModuleDefinition;
import com.sun.enterprise.v3.deployment.GenericSniffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.container.Sniffer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service(name="rails")
@Scoped(value=Singleton.class)
public class RailsSniffer
extends GenericSniffer
implements Sniffer {
    @Inject
    Habitat habitat;
    @Inject
    ModulesRegistry registry;
    final String[] containers = new String[]{"com.sun.enterprise.rails.RailsContainer"};

    public RailsSniffer() {
        super("jruby", "app/controllers/application.rb", null);
    }

    public Module[] setup(String containerHome, Logger logger) throws IOException {
        super.setup(containerHome, logger);
        File rootLocation = new File(containerHome);
        if (!rootLocation.exists()) {
            throw new RuntimeException("JRuby installation not found at " + rootLocation.getPath());
        }
        Module m = null;
        rootLocation = new File(rootLocation, "lib");
        String moduleSystem = System.getProperty("GlassFish_Platform");
        try {
            if (moduleSystem == null || moduleSystem.equals("HK2")) {
                m = this.setUpHk2(rootLocation);
            } else {
                this.setUpOSGi(rootLocation);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Cannot setup jruby classpath", e);
            throw e;
        }
        Module grizzlyRails = this.registry.makeModuleFor("org.glassfish.external:grizzly-jruby-module", null);
        if (grizzlyRails == null) {
            logger.log(Level.SEVERE, "Cannot find the grizzly-jruby-module");
            throw new IOException("cannot find the grizzly-jruby-module");
        }
        if (m != null) {
            grizzlyRails.addImport(m);
        }
        Module[] modules = new Module[]{grizzlyRails};
        return modules;
    }

    private Module setUpHk2(File libDirectory) throws IOException {
        Attributes jrubyAttr = new Attributes();
        StringBuffer classpath = new StringBuffer();
        for (File lib : libDirectory.listFiles()) {
            if (!lib.isFile() || lib.getName().equals("jruby.jar") || !lib.getName().endsWith(".jar")) continue;
            classpath.append(lib.getName());
            classpath.append(" ");
        }
        jrubyAttr.putValue(Attributes.Name.CLASS_PATH.toString(), classpath.toString());
        jrubyAttr.putValue("HK2-Bundle-Name", "org.jruby:jruby-complete");
        CookedModuleDefinition jruby = new CookedModuleDefinition(new File(libDirectory, "jruby.jar"), jrubyAttr);
        return this.registry.add((ModuleDefinition)jruby);
    }

    private Module setUpOSGi(File libDirectory) throws IOException {
        File manifestFile = new File(libDirectory, "META-INF/MANIFEST.MF");
        if (!(manifestFile = manifestFile.getCanonicalFile()).exists()) {
            Manifest m = new Manifest();
            m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            m.getMainAttributes().putValue("Bundle-SymbolicName", "org.jruby.jruby");
            StringBuffer classpath = new StringBuffer();
            for (File lib : libDirectory.listFiles()) {
                if (!lib.isFile()) continue;
                classpath.append(lib.getName());
                classpath.append(",");
            }
            m.getMainAttributes().putValue("Bundle-ClassPath", classpath.toString());
            m.getMainAttributes().putValue("Export-Package", "org.jruby,org.jruby.exceptions,org.jruby.runtime.builtin,org.jruby.javasupport,org.jruby.runtime.load,org.jruby.internal.runtime,org.jruby.runtime.callback,org.jruby.javasupport.util,org.jruby.ast.executable,org.jruby.runtime,org.jruby.libraries");
            try {
                if (!manifestFile.getParentFile().exists() && !manifestFile.getParentFile().mkdirs()) {
                    throw new IOException("Cannot create manifest file in jruby installation, do you have write access ?");
                }
                if (!manifestFile.createNewFile()) {
                    throw new IOException("Cannot create manifest file in jruby installation, do you have write access ?");
                }
                FileOutputStream out = new FileOutputStream(manifestFile);
                m.write(System.out);
                m.write(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Attributes jrubyAttr = new Attributes();
        jrubyAttr.putValue("HK2-Bundle-Name", "org.jruby:jruby-complete");
        CookedModuleDefinition jruby = new CookedModuleDefinition(libDirectory, jrubyAttr);
        return this.registry.add((ModuleDefinition)jruby);
    }

    public String[] getContainersNames() {
        return this.containers;
    }

    public boolean isUserVisible() {
        return true;
    }
}

