/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.admin.cli.RemoteCommandParser;
import com.sun.enterprise.admin.cli.deployment.FileUploadUtil;
import com.sun.enterprise.admin.cli.util.AuthenticationInfo;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.admin.cli.util.HttpConnectorAddress;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.universal.StringUtils;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Manifest;
import java.util.logging.Level;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommand {
    private static final CLILogger logger = CLILogger.getInstance();
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    private static final String MAGIC = "PlainTextActionReporter";
    private boolean verbose = false;
    private boolean terse = false;
    private boolean echo = false;
    private Map<String, Map<String, String>> serverResponse;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteCommand.class);
    private LoginInfoStore store = null;

    public RemoteCommand() {
    }

    public RemoteCommand(String ... args) throws CommandException {
        this.handleRemoteCommand(args);
    }

    public void handleRemoteCommand(String ... args) throws CommandException {
        this.handleRemoteCommand(args, "hk2-cli", (OutputStream)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRemoteCommand(String[] args, String responseFormatType, OutputStream userOut) throws CommandException {
        if (args.length == 0) {
            throw new CommandException(strings.get("remote.noargs"));
        }
        try {
            String msg;
            RemoteCommandParser rcp = new RemoteCommandParser(args);
            logger.printDebugMessage("RemoteCommandParser: " + rcp);
            Map<String, String> params = rcp.getOptions();
            this.setBooleans(params);
            if (this.terse) {
                logger.setOutputLevel(Level.INFO);
            } else {
                logger.setOutputLevel(Level.FINE);
            }
            Vector operands = rcp.getOperands();
            if (this.echo) {
                logger.printMessage(this.toString(args[0], params, operands));
            } else if (logger.isDebug()) {
                logger.printDebugMessage(this.toString(args[0], params, operands));
            }
            boolean uploadFile = this.getUploadFile(params.get("upload"), rcp.getCommandName(), operands.size() > 0 ? (String)operands.firstElement() : params.get("path"));
            File fileName = null;
            String hostName = params.get("host") == null ? "localhost" : params.get("host");
            String hostPort = params.get("port") == null ? "8080" : params.get("port");
            String secure = params.get("secure") == null ? "false" : params.get("secure");
            boolean isSecure = Boolean.parseBoolean(secure);
            String user = null;
            String password = null;
            Map<String, String> passwordOptions = null;
            if (params.get("passwordfile") != null) {
                passwordOptions = CLIUtil.readPasswordFileOptions(params.get("passwordfile"), true);
            }
            try {
                this.store = LoginInfoStoreFactory.getDefaultStore();
            }
            catch (StoreException se) {
                throw new CommandException(se);
            }
            LoginInfo li = this.store.read(hostName, Integer.parseInt(hostPort));
            user = this.getUser(li, params);
            password = this.getPassword(li, params);
            String uriConnection = "/__asadmin/" + rcp.getCommandName();
            for (Map.Entry<String, String> param : params.entrySet()) {
                String paramName = param.getKey();
                if (paramName.equals("host") || paramName.equals("port") || paramName.equals("upload") || paramName.equals("user") || paramName.equals("passwordfile") || paramName.equals("secure") || paramName.equals("terse") || paramName.equals("echo") || paramName.equals("interactive")) continue;
                try {
                    String paramValue = param.getValue();
                    if (paramName.equals("path")) {
                        fileName = new File(paramValue);
                        paramValue = this.getFileParam(uploadFile, fileName);
                    }
                    uriConnection = uriConnection + "?" + paramName + "=" + URLEncoder.encode(paramValue, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.printError("Error encoding " + paramName + ", parameter value will be ignored");
                }
            }
            BASE64Encoder base64encoder = new BASE64Encoder();
            if (passwordOptions != null) {
                for (String passwdName : passwordOptions.keySet()) {
                    String encodedpasswd = base64encoder.encode(passwordOptions.get(passwdName).getBytes());
                    uriConnection = uriConnection + "?" + passwdName + "=" + encodedpasswd;
                }
            }
            for (int ii = 0; ii < operands.size(); ++ii) {
                String operand = (String)operands.get(ii);
                if (rcp.getCommandName().equals("deploy") || rcp.getCommandName().equals("redeploy")) {
                    fileName = new File(operand);
                    String fileParam = this.getFileParam(uploadFile, fileName);
                    uriConnection = uriConnection + "?path=" + URLEncoder.encode(fileParam, "UTF-8");
                    break;
                }
                uriConnection = uriConnection + "?DEFAULT=" + URLEncoder.encode(operand, "UTF-8");
            }
            HttpURLConnection urlConnection = null;
            try {
                InputStream in;
                HttpConnectorAddress url = new HttpConnectorAddress(hostName, Integer.parseInt(hostPort), isSecure);
                logger.printDebugMessage("URL: " + url.toURL(uriConnection).toString());
                url.setAuthenticationInfo(new AuthenticationInfo(user, password));
                if (fileName != null && uploadFile) {
                    if (!fileName.exists()) throw new CommandException("File " + fileName.getName() + " does not exist.");
                    urlConnection = FileUploadUtil.upload(url.toURL(uriConnection).toString(), fileName);
                    in = urlConnection.getInputStream();
                    this.handleResponse(params, in, urlConnection.getResponseCode());
                    return;
                } else {
                    urlConnection = (HttpURLConnection)url.openConnection(uriConnection);
                    urlConnection.setRequestProperty("User-Agent", responseFormatType);
                    urlConnection.setRequestProperty("Authorization", url.getBasicAuthString());
                    urlConnection.connect();
                    in = urlConnection.getInputStream();
                    this.handleResponse(params, in, urlConnection.getResponseCode(), userOut);
                }
                return;
            }
            catch (ConnectException ce) {
                msg = strings.get("ConnectException", new Object[]{hostName, hostPort});
                throw new CommandException(msg, ce);
            }
            catch (IOException e) {
                int rc;
                msg = null;
                msg = urlConnection != null ? (401 == (rc = urlConnection.getResponseCode()) ? strings.get("InvalidCredentials", new Object[]{user}) : "Status: " + rc) : "Unknown Error";
                throw new CommandException(msg, e);
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            logger.printExceptionStackTrace(e);
            throw new CommandException(e);
        }
    }

    String getFileParam(boolean uploadFile, File fileName) {
        if (fileName == null) {
            return null;
        }
        String paramValue = fileName.getName();
        if (fileName.exists() && !uploadFile) {
            try {
                paramValue = fileName.getCanonicalPath();
            }
            catch (IOException ioe) {
                paramValue = fileName.getAbsolutePath();
            }
        }
        return paramValue;
    }

    boolean getUploadFile(String uploadOption, String commandName, String fileName) {
        boolean uploadFile = Boolean.parseBoolean(uploadOption);
        if (fileName != null && (commandName.equals("deploy") || commandName.equals("redeploy"))) {
            if (new File(fileName).isDirectory()) {
                uploadFile = false;
            } else if (uploadOption == null) {
                uploadFile = true;
            }
        }
        return uploadFile;
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code, OutputStream userOut) throws IOException, CommandException {
        if (userOut == null) {
            this.handleResponse(params, in, code);
        } else {
            this.copyStream(in, userOut);
        }
    }

    private void handleResponse(Map<String, String> params, InputStream in, int code) throws IOException, CommandException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copyStream(in, baos);
        String responseString = baos.toString();
        in = new ByteArrayInputStream(baos.toByteArray());
        logger.printDebugMessage("--------  RESPONSE DUMP         --------------");
        logger.printDebugMessage(responseString);
        logger.printDebugMessage("----------------------------------------------");
        if (code != 200) {
            throw new CommandException("Failed : error code " + code);
        }
        try {
            this.serverResponse = this.getServerData(in);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.serverResponse == null) {
            this.processPlainText(responseString);
        } else if (params.size() == 1 && params.get("help") != null) {
            this.processHelp(this.serverResponse);
        } else {
            this.processMessage(this.serverResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> getServerData(InputStream is) throws IOException {
        try {
            Map serverResponse;
            Manifest m = new Manifest();
            m.read(is);
            Map map = serverResponse = ManifestUtils.normalize((Manifest)m);
            return map;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void processHelp(Map<String, Map<String, String>> serverResponse) throws CommandException {
        StringTokenizer token;
        Map<String, String> mainAtts = serverResponse.get("main");
        if (this.processManPage(mainAtts)) {
            return;
        }
        String usageText = mainAtts.get("SYNOPSYS_value");
        if (usageText == null) {
            throw new CommandException(strings.get("remoteError", new Object[]{mainAtts.get("message")}));
        }
        System.out.println("NAME :");
        this.displayInProperLen(mainAtts.get("message"));
        System.out.println("");
        System.out.println("SYNOPSIS :");
        if (usageText.startsWith("Usage: ")) {
            System.out.println("\t" + mainAtts.get("SYNOPSYS_value").substring(7));
        } else {
            System.out.println("\t" + mainAtts.get("SYNOPSYS_value"));
        }
        System.out.println("");
        boolean displayOptionTitle = true;
        String keys = mainAtts.get("keys");
        ArrayList<String> operands = new ArrayList<String>();
        if (keys != null && (token = new StringTokenizer(keys, ";")).hasMoreTokens()) {
            while (token.hasMoreTokens()) {
                String property = token.nextToken();
                if (property.endsWith("operand")) {
                    operands.add(property);
                    continue;
                }
                if (property.endsWith("SYNOPSYS")) continue;
                if (displayOptionTitle) {
                    System.out.println("OPTIONS : ");
                    displayOptionTitle = false;
                }
                String name = mainAtts.get(property + "_name");
                String value = mainAtts.get(property + "_value");
                logger.printMessage("\t--" + name);
                this.displayInProperLen(value);
                logger.printMessage("");
            }
        }
        this.displayOperands(operands, mainAtts);
    }

    private boolean processManPage(Map<String, String> mainAtts) throws CommandException {
        String manPage = mainAtts.get("MANPAGE_value");
        if (!this.ok(manPage)) {
            return false;
        }
        logger.printMessage(manPage);
        return true;
    }

    private void displayOperands(List<String> operands, Map<String, String> mainAtts) {
        if (!operands.isEmpty()) {
            System.out.println("OPERANDS : ");
            for (String operand : operands) {
                String value = mainAtts.get(operand + "_value");
                String displayStr = operand.substring(0, operand.length() - 8) + " - " + value;
                this.displayInProperLen(displayStr);
                logger.printMessage("");
            }
        }
    }

    private void displayInProperLen(String strToDisplay) {
        int index = 0;
        int ii = 0;
        while (ii + 70 < strToDisplay.length()) {
            index = ii + 70;
            String subStr = strToDisplay.substring(ii, index + 1);
            if (subStr.endsWith(" ") || subStr.endsWith(",") || subStr.endsWith(".") || subStr.endsWith("-")) {
                logger.printMessage("\t" + subStr);
                ++ii;
                ++index;
            } else {
                logger.printMessage("\t" + strToDisplay.substring(ii, index) + "-");
            }
            ii += 70;
        }
        if (index < strToDisplay.length()) {
            logger.printMessage("\t" + strToDisplay.substring(index));
        }
    }

    private void processMessage(Map<String, Map<String, String>> serverResponse) throws CommandException {
        Map<String, String> mainAtts = serverResponse.get("main");
        String exitCode = mainAtts.get("exit-code");
        String message = mainAtts.get("message");
        if (exitCode == null || exitCode.equalsIgnoreCase("Success")) {
            if (this.ok(message)) {
                logger.printMessage(message);
            }
            this.processOneLevel("", null, serverResponse, mainAtts);
            return;
        }
        String childMsg = mainAtts.get("children");
        if (childMsg != null && !childMsg.equals("")) {
            StringTokenizer childTok = new StringTokenizer(childMsg, ";");
            while (childTok.hasMoreTokens()) {
                logger.printMessage(childTok.nextToken());
            }
        }
        message = this.ok(message) ? exitCode + " : " + message : exitCode;
        String cause = mainAtts.get("cause");
        if (CLILogger.isDebug() && this.ok(cause)) {
            message = message + StringUtils.NEWLINE + strings.get("cause", new Object[]{cause});
        }
        throw new CommandException(message);
    }

    private void processOneLevel(String prefix, String key, Map<String, Map<String, String>> serverResponse, Map<String, String> atts) {
        String children;
        if (atts == null) {
            return;
        }
        String keys = atts.get("keys");
        String output = "";
        if (keys != null) {
            StringTokenizer token = new StringTokenizer(keys, ";");
            boolean displayProperties = false;
            while (token.hasMoreTokens()) {
                String property = token.nextToken();
                if (!property.startsWith("nb-")) {
                    if (!displayProperties) {
                        output = output + prefix + "properties=(";
                        displayProperties = true;
                    }
                    String name = atts.get(property + "_name");
                    String value = atts.get(property + "_value");
                    output = output + name + "=" + value;
                    if (token.hasMoreElements()) {
                        output = output + ",";
                    }
                }
                if (!displayProperties) continue;
                output = output + ")";
                logger.printMessage(output);
                output = "";
            }
        }
        if ((children = atts.get("children")) == null) {
            return;
        }
        String childrenType = atts.get("children-type");
        StringTokenizer token = new StringTokenizer(children, ";");
        while (token.hasMoreTokens()) {
            int index;
            String container = token.nextToken();
            int n = index = key == null ? 0 : key.length() + 1;
            if (childrenType.equals("null") || childrenType.equals("")) {
                logger.printMessage(container.substring(index));
            } else {
                logger.printMessage(prefix + childrenType + " : " + container.substring(index));
            }
            Map<String, String> childAtts = serverResponse.get(container);
            this.processOneLevel(prefix + "\t", container, serverResponse, childAtts);
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        out.close();
    }

    private void processPlainText(String response) throws CommandException {
        if (response.startsWith(MAGIC)) {
            if ((response = response.substring(MAGIC.length())).startsWith(SUCCESS)) {
                logger.printMessage(response.substring(SUCCESS.length()));
            } else if (response.startsWith(FAILURE)) {
                throw new CommandException(strings.get("remoteError", new Object[]{response.substring(FAILURE.length())}));
            }
            return;
        }
        logger.printDetailMessage(strings.get("unknownFormat"));
        logger.printMessage(response);
    }

    private void setBooleans(Map<String, String> params) {
        String value;
        if (params.containsKey("verbose")) {
            value = params.get("verbose");
            this.verbose = this.ok(value) ? Boolean.parseBoolean(params.get("verbose")) : true;
        }
        if (params.containsKey("echo")) {
            value = params.get("echo");
            this.echo = this.ok(value) ? Boolean.parseBoolean(params.get("echo")) : true;
        }
        if (params.containsKey("terse")) {
            value = params.get("terse");
            this.terse = this.ok(value) ? Boolean.parseBoolean(params.get("terse")) : true;
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0 && !s.equals("null");
    }

    private String toString(String commandName, Map<String, String> params, Vector operands) {
        StringBuilder sb = new StringBuilder();
        sb.append(commandName).append(' ');
        sb.append("--echo=").append(Boolean.toString(this.echo)).append(' ');
        sb.append("--terse=").append(Boolean.toString(this.terse)).append(' ');
        Set<String> paramKeys = params.keySet();
        for (String key : paramKeys) {
            if (key.equals("terse") || key.equals("echo")) continue;
            String value = params.get(key);
            sb.append("--").append(key);
            if (this.ok(value)) {
                sb.append('=').append(value);
            }
            sb.append(' ');
        }
        for (String o : operands) {
            sb.append((Object)o).append(' ');
        }
        return sb.toString();
    }

    Map<String, Map<String, String>> getServerResponse() {
        return this.serverResponse;
    }

    static boolean pingDAS(int port) {
        try {
            new RemoteCommand("version", "--port", Integer.toString(port));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String getUser(LoginInfo li, Map<String, String> params) {
        String user = params.get("user");
        if (user == null && li != null) {
            user = li.getUser();
        }
        return user;
    }

    private String getPassword(LoginInfo li, Map<String, String> params) throws CommandException {
        Map<String, String> passwordOptions = null;
        String password = null;
        if (params.get("passwordfile") != null) {
            passwordOptions = CLIUtil.readPasswordFileOptions(params.get("passwordfile"), true);
            password = passwordOptions.get("AS_ADMIN_PASSWORD");
        }
        if (password == null && li != null) {
            password = li.getPassword();
        }
        return password;
    }
}

