/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.RemoteCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopDomainCommand
extends AbstractCommand {
    private File domainsDir;
    private File domainRootDir;
    private String domainName;
    private File domainXml;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDomainCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.getDomainRootDir();
        this.getDomainXml();
        this.domainRootDir = SmartFile.sanitize((File)this.domainRootDir);
        Integer[] ports = null;
        try {
            MiniXmlParser parser = new MiniXmlParser(this.domainXml);
            Set portsSet = parser.getAdminPorts();
            ports = portsSet.toArray(new Integer[portsSet.size()]);
        }
        catch (MiniXmlParserException ex) {
            throw new CommandValidationException(strings.get("StopDomain.parserError", new Object[]{ex}), ex);
        }
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            new RemoteCommand(this.getCmd(ports[0].toString()));
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    @Override
    public boolean validateOptions() throws CommandValidationException {
        String domaindir;
        super.validateOptions();
        if (!this.operands.isEmpty()) {
            this.domainName = (String)this.operands.firstElement();
        }
        if (StopDomainCommand.ok(domaindir = this.getOption("domaindir"))) {
            this.domainsDir = new File(domaindir);
            if (!this.domainsDir.isDirectory()) {
                throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
            }
        }
        return true;
    }

    private String[] getCmd(String port) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("stop-domain");
        this.addOption(cmd, "host");
        this.addOption(cmd, "port");
        this.addOption(cmd, "user");
        this.addOption(cmd, "passwordfile");
        String[] holdingArray = new String[cmd.size()];
        return cmd.toArray(holdingArray);
    }

    private void addOption(List<String> cmd, String option) {
        String value = this.getOption(option);
        if (value != null) {
            cmd.add("--" + option);
            cmd.add(value);
        }
    }

    private void getDomainRootDir() throws CommandValidationException {
        if (this.domainsDir == null) {
            this.domainsDir = new File(this.getSystemProperty("com.sun.aas.domainsRoot"));
        }
        if (!this.domainsDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainsDir", new Object[]{this.domainsDir}));
        }
        this.domainRootDir = this.domainName != null ? new File(this.domainsDir, this.domainName) : this.getTheOneAndOnlyDomain(this.domainsDir);
        if (!this.domainRootDir.isDirectory()) {
            throw new CommandValidationException(strings.get("StopDomain.badDomainDir", new Object[]{this.domainRootDir}));
        }
    }

    private void getDomainXml() throws CommandValidationException {
        this.domainXml = new File(this.domainRootDir, "config/domain.xml");
        if (!this.domainXml.canRead()) {
            throw new CommandValidationException(strings.get("StopDomain.noDomainXml", new Object[]{this.domainXml}));
        }
    }

    private File getTheOneAndOnlyDomain(File parent) throws CommandValidationException {
        File[] files = parent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandValidationException(strings.get("noDomainDirs", new Object[]{parent}));
        }
        if (files.length > 1) {
            throw new CommandValidationException(strings.get("StopDomain.tooManyDomainDirs", new Object[]{parent}));
        }
        return files[0];
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

