/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.config.TemplateResolver;

public class TemplateResolverHelper {
    private final TemplateResolver mResolver;

    public TemplateResolverHelper(TemplateResolver resolver) {
        this.mResolver = resolver;
    }

    public static boolean isTemplateString(String s) {
        if (s == null) {
            return false;
        }
        String temp = s.trim();
        return temp.startsWith("${") && temp.endsWith("}");
    }

    public String resolve(String in) {
        return TemplateResolverHelper.resolve(this.mResolver, in);
    }

    public static String resolve(TemplateResolver resolver, String in) {
        return TemplateResolverHelper.isTemplateString(in) ? resolver.resolveTemplateString(in) : in;
    }

    public boolean resolveBoolean(String templateString) {
        return TemplateResolverHelper.resolveBoolean(this.mResolver, templateString);
    }

    public static boolean resolveBoolean(TemplateResolver resolver, String templateString) {
        String resolved = TemplateResolverHelper.resolve(resolver, templateString);
        return Boolean.parseBoolean(resolved);
    }

    public int resolveInt(String templateString) {
        return TemplateResolverHelper.resolveInt(this.mResolver, templateString);
    }

    public static int resolveInt(TemplateResolver resolver, String templateString) {
        String resolved = TemplateResolverHelper.resolve(resolver, templateString);
        return Integer.parseInt(resolved);
    }
}

