/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.InOutputParameterForCallableStatement;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public abstract class DatabaseCall
extends DatasourceCall {
    protected boolean ignoreFirstRowMaxResultsSettings = false;
    public static DatabaseField MAXROW_FIELD = new DatabaseField("TopLink-MaxResults");
    public static DatabaseField FIRSTRESULT_FIELD = new DatabaseField("TopLink-FirstRow");
    protected transient Statement statement;
    protected transient ResultSet result;
    protected Boolean usesBinding;
    protected Boolean shouldCacheStatement;
    protected transient Vector fields;
    protected boolean isFieldMatchingRequired;
    protected boolean hasOptimisticLock;
    protected boolean isResultSetScrollable;
    protected int resultSetFetchSize;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int queryTimeout;
    protected int maxRows;
    protected int firstResult;
    private transient AbstractRecord contexts = null;
    protected boolean isCursorOutputProcedure;
    protected Boolean returnsResultSet;
    protected boolean shouldBuildOutputRow;
    protected boolean isCallableStatementRequired;
    protected String sqlString;

    public DatabaseCall() {
        this.shouldProcessTokenInQuotes = false;
        this.usesBinding = null;
        this.shouldCacheStatement = null;
        this.isFieldMatchingRequired = false;
        this.returnType = 3;
        this.queryTimeout = 0;
        this.maxRows = 0;
        this.resultSetFetchSize = 0;
        this.isCursorOutputProcedure = false;
        this.shouldBuildOutputRow = false;
        this.returnsResultSet = null;
    }

    public void appendIn(Object inObject) {
        this.getParameters().add(inObject);
        this.getParameterTypes().add(IN);
    }

    public void appendInOut(DatabaseField inoutField) {
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(INOUT);
    }

    public void appendInOut(Object inValueOrField, DatabaseField outField) {
        Object[] inOut = new Object[]{inValueOrField, outField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(INOUT);
    }

    public void appendOut(DatabaseField outField) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(OUT);
    }

    public void appendOutCursor(DatabaseField outField) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(OUT_CURSOR);
    }

    public void appendParameter(Writer writer, Object parameter, AbstractSession session) {
        if (Boolean.TRUE.equals(this.usesBinding)) {
            this.bindParameter(writer, parameter);
        } else {
            session.getPlatform().appendParameter(this, writer, parameter);
        }
    }

    public void bindParameter(Writer writer, Object parameter) {
        if (parameter instanceof Collection) {
            throw QueryException.inCannotBeParameterized(this.getQuery());
        }
        try {
            writer.write("?");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(parameter);
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new CallQueryMechanism(query, this);
    }

    public AbstractRecord buildOutputRow(CallableStatement statement) throws SQLException {
        DatabaseRecord row = new DatabaseRecord();
        for (int index = 0; index < this.parameters.size(); ++index) {
            OutputParameterForCallableStatement outParameter;
            Object parameter = this.parameters.elementAt(index);
            if (!(parameter instanceof OutputParameterForCallableStatement) || (outParameter = (OutputParameterForCallableStatement)parameter).isCursor()) continue;
            Object value = statement.getObject(index + 1);
            DatabaseField field = outParameter.getOutputField();
            if (value instanceof Struct) {
                ClassDescriptor descriptor = this.getQuery().getSession().getDescriptor(field.getType());
                if (value != null && descriptor != null && descriptor.isObjectRelationalDataTypeDescriptor()) {
                    AbstractRecord nestedRow = ((ObjectRelationalDataTypeDescriptor)descriptor).buildRowFromStructure((Struct)value);
                    ReadObjectQuery query = new ReadObjectQuery();
                    query.setSession(this.getQuery().getSession());
                    value = descriptor.getObjectBuilder().buildObject(query, nestedRow);
                }
            } else if (value instanceof Array && field.isObjectRelationalDatabaseField()) {
                value = ObjectRelationalDataTypeDescriptor.buildContainerFromArray((Array)value, (ObjectRelationalDatabaseField)field, this.getQuery().getSession());
            }
            row.put(field, value);
        }
        return row;
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof CallQueryMechanism) {
            CallQueryMechanism callMechanism = (CallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        if (outParameter instanceof OutputParameterForCallableStatement) {
            return new InOutputParameterForCallableStatement(inValue, (OutputParameterForCallableStatement)outParameter);
        }
        if (outParameter instanceof DatabaseField) {
            return new InOutputParameterForCallableStatement(inValue, (DatabaseField)outParameter, session);
        }
        return null;
    }

    public String getCallString() {
        return this.getSQLString();
    }

    public Vector getFields() {
        return this.fields;
    }

    protected DatabaseField getFieldWithTypeFromDescriptor(DatabaseField outField) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().getTypedField(outField);
        }
        return null;
    }

    public int getCursorOutIndex() {
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Object parameter = this.getParameters().elementAt(i);
            if (!(parameter instanceof OutputParameterForCallableStatement) || !((OutputParameterForCallableStatement)parameter).isCursor()) continue;
            return i + 1;
        }
        return -1;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public String getLogString(Accessor accessor) {
        if (this.hasParameters()) {
            StringWriter writer = new StringWriter();
            writer.write(this.getSQLString());
            writer.write(Helper.cr());
            if (this.hasParameters()) {
                AbstractSession session = null;
                if (this.getQuery() != null) {
                    session = this.getQuery().getSession();
                }
                DatabaseCall.appendLogParameters(this.getParameters(), accessor, writer, session);
            }
            return writer.toString();
        }
        return this.getSQLString();
    }

    public static void appendLogParameters(Collection parameters, Accessor accessor, StringWriter writer, AbstractSession session) {
        writer.write("\tbind => [");
        Iterator paramsEnum = parameters.iterator();
        while (paramsEnum.hasNext()) {
            Object parameter = paramsEnum.next();
            if (parameter instanceof DatabaseField) {
                writer.write("null");
            } else {
                if (session != null) {
                    parameter = session.getPlatform().convertToDatabaseType(parameter);
                }
                writer.write(String.valueOf(parameter));
            }
            if (paramsEnum.hasNext()) {
                writer.write(", ");
                continue;
            }
            writer.write("]");
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Vector getOutputRowFields() {
        Vector<Object> fields = new Vector<Object>();
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Integer parameterType = (Integer)this.getParameterTypes().elementAt(i);
            Object parameter = this.getParameters().elementAt(i);
            if (parameterType == OUT) {
                fields.add(parameter);
                continue;
            }
            if (parameterType != INOUT) continue;
            fields.add(((Object[])parameter)[1]);
        }
        return fields;
    }

    public String getQueryString() {
        return this.getSQLString();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public boolean getReturnsResultSet() {
        if (this.returnsResultSet == null) {
            return !this.shouldBuildOutputRow();
        }
        return this.returnsResultSet;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetFetchSize() {
        return this.resultSetFetchSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public String getSQLString() {
        return this.sqlString;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean hasOptimisticLock() {
        return this.hasOptimisticLock;
    }

    protected boolean isCallableStatementRequired() {
        return this.isCallableStatementRequired;
    }

    protected boolean isDynamicCall(AbstractSession session) {
        return DatabaseAccessor.shouldUseDynamicStatements && !this.usesBinding(session) && !this.isResultSetScrollable() && !this.hasParameters();
    }

    public boolean isCursorOutputProcedure() {
        return this.isCursorOutputProcedure;
    }

    public boolean isCursorReturned() {
        return this.getReturnType() == 4;
    }

    public boolean isFieldMatchingRequired() {
        return this.isFieldMatchingRequired;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNonCursorOutputProcedure() {
        return !this.isCursorOutputProcedure() && this.shouldBuildOutputRow();
    }

    public boolean isResultSetScrollable() {
        return this.isResultSetScrollable;
    }

    public void matchFieldOrder(ResultSet resultSet, DatabaseAccessor accessor, AbstractSession session) {
        if (this.getFields() != null && !this.isFieldMatchingRequired()) {
            return;
        }
        this.setFields(accessor.buildSortedFields(this.getFields(), resultSet, session));
    }

    public void prepare(AbstractSession session) {
        if (this.isPrepared()) {
            return;
        }
        this.prepareInternal(session);
        this.setIsPrepared(true);
    }

    protected void prepareInternal(AbstractSession session) {
        this.prepareInternalParameters(session);
    }

    protected void prepareInternalParameters(AbstractSession session) {
        if (this.isCursorOutputProcedure()) {
            int nFirstOutParameterIndex = -1;
            boolean hasFoundOutCursor = false;
            for (int index = 0; index < this.parameters.size(); ++index) {
                Integer parameterType = (Integer)this.parameterTypes.elementAt(index);
                if (parameterType == DatasourceCall.OUT_CURSOR) {
                    if (hasFoundOutCursor) {
                        throw ValidationException.multipleCursorsNotSupported(this.toString());
                    }
                    hasFoundOutCursor = true;
                    continue;
                }
                if (parameterType == DatasourceCall.OUT) {
                    if (nFirstOutParameterIndex != -1) continue;
                    nFirstOutParameterIndex = index;
                    continue;
                }
                if (parameterType != null) continue;
                throw ValidationException.wrongUsageOfSetCustomArgumentTypeMethod(this.toString());
            }
            if (!hasFoundOutCursor && nFirstOutParameterIndex >= 0) {
                this.parameterTypes.setElementAt(DatasourceCall.OUT_CURSOR, nFirstOutParameterIndex);
            }
        }
        for (int i = 0; i < this.getParameters().size(); ++i) {
            DatabaseField typeOutField;
            boolean isCursor;
            Object parameter = this.getParameters().elementAt(i);
            Integer parameterType = (Integer)this.getParameterTypes().elementAt(i);
            if (parameterType == MODIFY) {
                DatabaseField field = (DatabaseField)parameter;
                if (field.getType() != null && !session.getPlatform().shouldUseCustomModifyForCall(field)) continue;
                this.getParameterTypes().setElementAt(CUSTOM_MODIFY, i);
                continue;
            }
            if (parameterType == INOUT) {
                DatabaseField typeOutField2;
                this.setShouldBuildOutputRow(true);
                this.setIsCallableStatementRequired(true);
                DatabaseField outField = (DatabaseField)((Object[])parameter)[1];
                if (outField.getType() == null && (typeOutField2 = this.getFieldWithTypeFromDescriptor(outField)) != null) {
                    outField = (DatabaseField)typeOutField2.clone();
                }
                if (outField.getType() == null) continue;
                OutputParameterForCallableStatement outParameter = new OutputParameterForCallableStatement(outField, session);
                ((Object[])parameter)[1] = outParameter;
                continue;
            }
            if (parameterType != OUT && parameterType != OUT_CURSOR) continue;
            boolean bl = isCursor = parameterType == OUT_CURSOR;
            if (!isCursor) {
                this.setShouldBuildOutputRow(true);
            }
            this.setIsCallableStatementRequired(true);
            DatabaseField outField = (DatabaseField)parameter;
            if (outField.getType() == null && (typeOutField = this.getFieldWithTypeFromDescriptor(outField)) != null) {
                outField = (DatabaseField)typeOutField.clone();
            }
            OutputParameterForCallableStatement outParameter = new OutputParameterForCallableStatement(outField, session, isCursor);
            this.getParameters().setElementAt(outParameter, i);
            this.getParameterTypes().setElementAt(LITERAL, i);
        }
        if (this.returnsResultSet == null) {
            this.setReturnsResultSet(!this.isCallableStatementRequired());
        }
    }

    public Statement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        Statement statement = accessor.prepareStatement(this, session, this.shouldUnwrapConnection);
        if (this.getQueryTimeout() > 0) {
            statement.setQueryTimeout(this.getQueryTimeout());
        }
        if (!this.ignoreFirstRowMaxResultsSettings && this.getMaxRows() > 0) {
            statement.setMaxRows(this.getMaxRows());
        }
        if (this.getResultSetFetchSize() > 0) {
            statement.setFetchSize(this.getResultSetFetchSize());
        }
        if (!this.hasParameters()) {
            return statement;
        }
        for (int index = 0; index < this.getParameters().size(); ++index) {
            session.getPlatform().setParameterValueInDatabaseCall(this.getParameters(), (PreparedStatement)statement, index, session);
        }
        return statement;
    }

    public void setFields(Vector fields) {
        this.fields = fields;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setHasOptimisticLock(boolean hasOptimisticLock) {
        this.hasOptimisticLock = hasOptimisticLock;
    }

    public void setIgnoreFirstRowMaxResultsSettings(boolean ignoreFirstRowMaxResultsSettings) {
        this.ignoreFirstRowMaxResultsSettings = ignoreFirstRowMaxResultsSettings;
    }

    protected void setIsCallableStatementRequired(boolean isCallableStatementRequired) {
        this.isCallableStatementRequired = isCallableStatementRequired;
    }

    public void setIsCursorOutputProcedure(boolean isCursorOutputProcedure) {
        this.isCursorOutputProcedure = isCursorOutputProcedure;
    }

    public void setIsFieldMatchingRequired(boolean isFieldMatchingRequired) {
        this.isFieldMatchingRequired = isFieldMatchingRequired;
    }

    public void setIsResultSetScrollable(boolean isResultSetScrollable) {
        this.isResultSetScrollable = isResultSetScrollable;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setQueryString(String queryString) {
        this.setSQLStringInternal(queryString);
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setResult(ResultSet result) {
        this.result = result;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    protected void setSQLStringInternal(String sqlString) {
        this.sqlString = sqlString;
    }

    public void setResultSetFetchSize(int resultSetFetchSize) {
        this.resultSetFetchSize = resultSetFetchSize;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setReturnsResultSet(boolean returnsResultSet) {
        this.returnsResultSet = returnsResultSet;
    }

    protected void setShouldBuildOutputRow(boolean shouldBuildOutputRow) {
        this.shouldBuildOutputRow = shouldBuildOutputRow;
    }

    public void setShouldCacheStatement(boolean shouldCacheStatement) {
        this.shouldCacheStatement = shouldCacheStatement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setUsesBinding(boolean usesBinding) {
        this.usesBinding = usesBinding;
    }

    public boolean shouldBuildOutputRow() {
        return this.shouldBuildOutputRow;
    }

    public boolean shouldCacheStatement(AbstractSession session) {
        return this.shouldCacheStatement(session.getPlatform());
    }

    public boolean shouldCacheStatement(DatabasePlatform databasePlatform) {
        if (this.isResultSetScrollable()) {
            return false;
        }
        if (this.shouldCacheStatement == null) {
            return databasePlatform.shouldCacheAllStatements();
        }
        return this.shouldCacheStatement;
    }

    public boolean shouldIgnoreFirstRowMaxResultsSettings() {
        return this.ignoreFirstRowMaxResultsSettings;
    }

    public String toString() {
        String str = Helper.getShortClassName(this.getClass());
        if (this.getSQLString() == null) {
            return str;
        }
        return str + "(" + this.getSQLString() + ")";
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (!this.isPrepared()) {
            throw ValidationException.cannotTranslateUnpreparedCall(this.toString());
        }
        if (this.usesBinding(session)) {
            boolean hasParameterizedIN = false;
            Vector parameters = this.getParameters();
            Vector parameterTypes = this.getParameterTypes();
            Vector<Object> parametersValues = new Vector<Object>(parameters.size());
            int size = parameters.size();
            for (int index = 0; index < size; ++index) {
                Object value;
                Object value2;
                DatabaseField field;
                Object parameter = parameters.get(index);
                Object parameterType = parameterTypes.get(index);
                if (parameterType == MODIFY) {
                    field = (DatabaseField)parameter;
                    value2 = modifyRow.get(field);
                    if (value2 == null && (value2 = modifyRow.getField(field)) == null) {
                        value2 = field;
                    }
                    parametersValues.add(value2);
                    continue;
                }
                if (parameterType == CUSTOM_MODIFY) {
                    field = (DatabaseField)parameter;
                    value2 = modifyRow.get(field);
                    value2 = session.getPlatform().getCustomModifyValueForCall(this, value2, field, true);
                    if (value2 != null && value2 instanceof BindCallCustomParameter && ((BindCallCustomParameter)value2).shouldUseUnwrappedConnection()) {
                        this.shouldUnwrapConnection = true;
                    }
                    if (value2 == null && (value2 = modifyRow.getField(field)) == null) {
                        value2 = field;
                    }
                    parametersValues.add(value2);
                    continue;
                }
                if (parameterType == TRANSLATION) {
                    value = null;
                    DatabaseField field2 = null;
                    if (parameter instanceof ParameterExpression) {
                        value = ((ParameterExpression)parameter).getValue(translationRow, session);
                    } else {
                        field2 = (DatabaseField)parameter;
                        value = translationRow.get(field2);
                        if (value == null) {
                            value = modifyRow.get(field2);
                        }
                    }
                    if (value instanceof Collection) {
                        hasParameterizedIN = true;
                    }
                    if (value == null && field2 != null && (value = translationRow.getField(field2)) == null) {
                        value = field2;
                    }
                    parametersValues.add(value);
                    continue;
                }
                if (parameterType == LITERAL) {
                    parametersValues.add(parameter);
                    continue;
                }
                if (parameterType == IN) {
                    value = this.getValueForInParameter(parameter, translationRow, modifyRow, session, true);
                    parametersValues.add(value);
                    continue;
                }
                if (parameterType != INOUT) continue;
                value = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                parametersValues.add(value);
            }
            this.setParameters(parametersValues);
            if (hasParameterizedIN) {
                this.translateQueryStringForParameterizedIN(translationRow, modifyRow, session);
            }
            return;
        }
        this.translateQueryString(translationRow, modifyRow, session);
    }

    public void translateQueryStringForParameterizedIN(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            Vector parameters = this.getParameters();
            Vector parametersValues = new Vector(parameters.size());
            while (lastIndex != -1) {
                String token;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token = queryString.substring(lastIndex, tokenIndex);
                }
                writer.write(token);
                if (tokenIndex == -1) continue;
                Object parameter = parameters.get(parameterIndex);
                if (parameter instanceof Collection) {
                    Vector values = (Vector)parameter;
                    parametersValues.addAll(values);
                    int size = values.size();
                    writer.write("(");
                    for (int index = 0; index < size; ++index) {
                        writer.write("?");
                        if (index + 1 >= size) continue;
                        writer.write(",");
                    }
                    writer.write(")");
                } else {
                    parametersValues.add(parameter);
                    writer.write("?");
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setParameters(parametersValues);
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public boolean usesBinding(AbstractSession session) {
        return this.usesBinding(session.getPlatform());
    }

    public boolean usesBinding(DatabasePlatform databasePlatform) {
        if (this.usesBinding == null) {
            return databasePlatform.shouldBindAllParameters();
        }
        return this.usesBinding;
    }

    public boolean isLOBLocatorNeeded() {
        return this.contexts != null;
    }

    public void addContext(DatabaseField field, Object value) {
        if (this.contexts == null) {
            this.contexts = new DatabaseRecord(2);
        }
        this.contexts.add(field, value);
    }

    public AbstractRecord getContexts() {
        return this.contexts;
    }

    public void setContexts(AbstractRecord contexts) {
        this.contexts = contexts;
    }

    public void useUnnamedCursorOutputAsResultSet() {
        this.setIsCursorOutputProcedure(true);
    }
}

