/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.JTATransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapper;
import org.eclipse.persistence.internal.jpa.transaction.TransactionWrapperImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements JpaEntityManager {
    protected TransactionWrapperImpl transaction = null;
    protected boolean isOpen = true;
    protected RepeatableWriteUnitOfWork extendedPersistenceContext;
    protected ServerSession serverSession;
    protected EntityManagerFactoryImpl factory;
    protected boolean extended;
    protected boolean propagatePersistenceContext;
    protected boolean beginEarlyTransaction = false;
    protected Map properties;
    private FlushModeType flushMode;

    public EntityManagerImpl(String sessionName, boolean propagatePersistenceContext, boolean extended) {
        this((ServerSession)SessionManager.getManager().getSession(sessionName), null, propagatePersistenceContext, extended);
        this.flushMode = FlushModeType.AUTO;
    }

    public EntityManagerImpl(ServerSession serverSession, boolean propagatePersistenceContext, boolean extended) {
        this(serverSession, null, propagatePersistenceContext, extended);
    }

    public EntityManagerImpl(ServerSession serverSession, Map properties, boolean propagatePersistenceContext, boolean extended) {
        this.serverSession = serverSession;
        this.detectTransactionWrapper();
        this.extended = true;
        this.propagatePersistenceContext = false;
        this.properties = properties;
        this.setBeginEarlyTransaction();
        this.flushMode = FlushModeType.AUTO;
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Map properties, boolean propagatePersistenceContext, boolean extended) {
        this.factory = factory;
        this.serverSession = factory.getServerSession();
        this.detectTransactionWrapper();
        this.extended = true;
        this.propagatePersistenceContext = false;
        this.properties = properties;
        this.setBeginEarlyTransaction();
        this.flushMode = FlushModeType.AUTO;
    }

    public void clear() {
        try {
            this.verifyOpen();
            if (this.isExtended()) {
                if (this.extendedPersistenceContext != null) {
                    if (this.checkForTransaction(false) == null) {
                        this.extendedPersistenceContext.clearForClose(true);
                        this.extendedPersistenceContext = null;
                    } else {
                        this.extendedPersistenceContext.clear(true);
                    }
                }
            } else {
                this.transaction.clear();
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void removeExtendedPersistenceContext() {
        this.extendedPersistenceContext = null;
    }

    public void persist(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            try {
                this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).registerNewObjectForPersist(entity, new IdentityHashMap());
            }
            catch (RuntimeException e) {
                if (ValidationException.class.isAssignableFrom(e.getClass())) {
                    throw new EntityExistsException(e.getLocalizedMessage(), (Throwable)e);
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T merge(T entity) {
        try {
            this.verifyOpen();
            return (T)this.mergeInternal(entity);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object mergeInternal(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
        }
        if (this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).getDeletedObjects().containsKey(entity)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_merge_removed_entity", new Object[]{entity}));
        }
        try {
            return this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).mergeCloneWithReferences(entity, 4, true);
        }
        catch (OptimisticLockException ole) {
            throw new javax.persistence.OptimisticLockException((Throwable)ole);
        }
    }

    public void remove(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended())).performRemove(entity, new IdentityHashMap());
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        try {
            this.verifyOpen();
            Session session = this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptor(entityClass);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_bean_class", new Object[]{entityClass}));
            }
            return (T)this.findInternal(descriptor, session, primaryKey);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object find(String entityName, Object primaryKey) {
        try {
            this.verifyOpen();
            Session session = this.getActiveSession();
            ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unknown_entitybean_name", new Object[]{entityName}));
            }
            return this.findInternal(descriptor, session, primaryKey);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected Object findInternal(ClassDescriptor descriptor, Session session, Object primaryKey) {
        List primaryKeyValues;
        if (primaryKey == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_pk"));
        }
        if (primaryKey instanceof List) {
            primaryKeyValues = (List)primaryKey;
        } else {
            if (descriptor.getCMPPolicy().getPKClass() != null && !descriptor.getCMPPolicy().getPKClass().isAssignableFrom(primaryKey.getClass())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{descriptor.getCMPPolicy().getPKClass(), primaryKey.getClass()}));
            }
            primaryKeyValues = descriptor.getCMPPolicy().createPkVectorFromKey(primaryKey, (AbstractSession)session);
        }
        ReadObjectQuery query = new ReadObjectQuery(descriptor.getJavaClass());
        query.setSelectionKey(primaryKeyValues);
        query.conformResultsInUnitOfWork();
        query.setIsExecutionClone(true);
        return session.executeQuery(query);
    }

    public void flush() {
        try {
            this.verifyOpen();
            try {
                this.getActivePersistenceContext(this.checkForTransaction(true)).writeChanges();
            }
            catch (RuntimeException e) {
                if (EclipseLinkException.class.isAssignableFrom(e.getClass())) {
                    throw new PersistenceException((Throwable)e);
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void detectTransactionWrapper() {
        if (this.serverSession.hasExternalTransactionController()) {
            this.setJTATransactionWrapper();
        } else {
            this.setEntityTransactionWrapper();
        }
    }

    public void refresh(Object entity) {
        try {
            this.verifyOpen();
            RepeatableWriteUnitOfWork uow = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
            if (!this.contains(entity, uow)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cant_refresh_not_managed_object", new Object[]{entity}));
            }
            ReadObjectQuery query = new ReadObjectQuery();
            query.setSelectionObject(entity);
            query.refreshIdentityMapResult();
            query.cascadeByMapping();
            query.setLockMode((short)0);
            query.setIsExecutionClone(true);
            Object refreshedEntity = null;
            refreshedEntity = uow.executeQuery(query);
            if (refreshedEntity == null) {
                throw new EntityNotFoundException(ExceptionLocalization.buildMessage("entity_no_longer_exists_in_db", new Object[]{entity}));
            }
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    public boolean contains(Object entity) {
        try {
            this.verifyOpen();
            if (entity == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            ClassDescriptor descriptor = (ClassDescriptor)this.getServerSession().getDescriptors().get(entity.getClass());
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{entity}));
            }
            if (!this.hasActivePersistenceContext()) {
                return false;
            }
            return this.contains(entity, this.getActivePersistenceContext(this.checkForTransaction(false)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected boolean contains(Object entity, UnitOfWork uow) {
        return ((UnitOfWorkImpl)uow).isObjectRegistered(entity) && !((UnitOfWorkImpl)uow).isObjectDeleted(entity);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass) {
        return this.createDescriptorNamedQuery(queryName, descriptorClass, null);
    }

    @Override
    public Query createDescriptorNamedQuery(String queryName, Class descriptorClass, Vector argumentTypes) {
        try {
            DatabaseQuery query;
            this.verifyOpen();
            ClassDescriptor descriptor = this.getServerSession().getDescriptor(descriptorClass);
            if (descriptor != null && (query = descriptor.getQueryManager().getLocalQueryByArgumentTypes(queryName, argumentTypes)) != null) {
                return new EJBQueryImpl(query, this);
            }
            return null;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNamedQuery(String name) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(name, this, true);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString) {
        try {
            this.verifyOpen();
            return new EJBQueryImpl(EJBQueryImpl.buildSQLDatabaseQuery(sqlString, false), this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createNativeQueryInternal(sqlString, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            this.verifyOpen();
            ResultSetMappingQuery query = new ResultSetMappingQuery();
            query.setSQLResultSetMappingName(resultSetMapping);
            query.setSQLString(sqlString);
            query.setIsUserDefined(true);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Session getActiveSession() {
        Object txn = this.checkForTransaction(false);
        if (txn == null && !this.isExtended()) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork();
        }
        return this.getActivePersistenceContext(txn);
    }

    public Object getDelegate() {
        try {
            this.verifyOpen();
            return this;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public FlushModeType getFlushMode() {
        try {
            this.verifyOpen();
            return this.flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public UnitOfWork getUnitOfWork() {
        return this.getActivePersistenceContext(this.checkForTransaction(false));
    }

    @Override
    public Session getSession() {
        if (this.checkForTransaction(false) == null) {
            return this.serverSession.acquireNonSynchronizedUnitOfWork();
        }
        return null;
    }

    public EntityTransaction getTransaction() {
        try {
            return ((TransactionWrapper)((Object)this.transaction)).getTransaction();
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Object getProperty(String name) {
        Object propertyValue = null;
        if (name == null) {
            return null;
        }
        if (this.properties != null) {
            propertyValue = this.properties.get(name);
        }
        if (propertyValue == null) {
            propertyValue = this.factory.getServerSession().getProperty(name);
        }
        return propertyValue;
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            this.verifyOpen();
            UnitOfWork session = (UnitOfWork)this.getActiveSession();
            Object reference = session.getReference(entityClass, primaryKey);
            if (reference == null) {
                Object[] args = new Object[]{primaryKey};
                String message = ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_reference", args);
                throw new EntityNotFoundException(message);
            }
            return (T)reference;
        }
        catch (RuntimeException exception) {
            this.setRollbackOnly();
            throw exception;
        }
    }

    @Override
    public ServerSession getServerSession() {
        return this.serverSession;
    }

    protected DatabaseQuery createNativeQueryInternal(String sqlString, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSQLString(sqlString);
        query.setIsUserDefined(true);
        return query;
    }

    @Override
    public Query createQuery(Expression expression, Class resultType) {
        try {
            this.verifyOpen();
            DatabaseQuery query = this.createQueryInternal(expression, resultType);
            return new EJBQueryImpl(query, this);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public Query createQuery(String jpqlString) {
        try {
            EJBQueryImpl ejbqImpl;
            this.verifyOpen();
            try {
                ejbqImpl = new EJBQueryImpl(jpqlString, this);
            }
            catch (JPQLException exception) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("wrap_ejbql_exception"), exception);
            }
            return ejbqImpl;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected DatabaseQuery createQueryInternal(Expression expression, Class resultType) {
        ReadAllQuery query = new ReadAllQuery(resultType);
        query.setSelectionCriteria(expression);
        return query;
    }

    public void close() {
        try {
            this.verifyOpen();
            this.isOpen = false;
            this.factory = null;
            this.serverSession = null;
            if (this.extendedPersistenceContext != null) {
                if (this.checkForTransaction(false) == null && !this.extendedPersistenceContext.isSynchronized()) {
                    this.extendedPersistenceContext.clearForClose(false);
                } else {
                    this.extendedPersistenceContext.setShouldClearForCloseInsteadOfResume(true);
                }
                this.extendedPersistenceContext = null;
            }
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isFlushModeAUTO() {
        return this.flushMode == FlushModeType.AUTO;
    }

    public boolean isOpen() {
        return this.isOpen && this.factory.isOpen();
    }

    public void lock(Object entity, LockModeType lockMode) {
        try {
            this.verifyOpen();
            RepeatableWriteUnitOfWork context = this.getActivePersistenceContext(this.checkForTransaction(!this.isExtended()));
            ClassDescriptor descriptor = context.getDescriptor(entity);
            OptimisticLockingPolicy lockingPolicy = descriptor.getOptimisticLockingPolicy();
            if (lockingPolicy == null || !(lockingPolicy instanceof VersionLockingPolicy)) {
                throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
            }
            context.forceUpdateToVersionField(entity, lockMode == LockModeType.WRITE);
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void verifyOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager"));
        }
    }

    public RepeatableWriteUnitOfWork getActivePersistenceContext(Object txn) {
        if (this.isExtended()) {
            if (this.extendedPersistenceContext == null || !this.extendedPersistenceContext.isActive()) {
                this.extendedPersistenceContext = new RepeatableWriteUnitOfWork(this.serverSession.acquireClientSession());
                this.extendedPersistenceContext.setResumeUnitOfWorkOnTransactionCompletion(true);
                this.extendedPersistenceContext.setShouldCascadeCloneToJoinedRelationship(true);
                this.extendedPersistenceContext.setProperties(this.properties);
                if (txn != null) {
                    this.transaction.registerUnitOfWorkWithTxn(this.extendedPersistenceContext);
                }
            }
            if (this.beginEarlyTransaction && txn != null && !this.extendedPersistenceContext.isInTransaction()) {
                this.extendedPersistenceContext.beginEarlyTransaction();
            }
            return this.extendedPersistenceContext;
        }
        return this.getTransactionalUnitOfWork_new(txn);
    }

    private boolean hasActivePersistenceContext() {
        return !this.isExtended() || this.extendedPersistenceContext != null && this.extendedPersistenceContext.isActive();
    }

    protected RepeatableWriteUnitOfWork getTransactionalUnitOfWork_new(Object tnx) {
        return this.transaction.getTransactionalUnitOfWork(tnx);
    }

    protected Object checkForTransaction(boolean validateExistence) {
        return this.transaction.checkForTransaction(validateExistence);
    }

    public boolean shouldFlushBeforeQuery() {
        Object foundTransaction = this.checkForTransaction(false);
        return foundTransaction != null && this.transaction.shouldFlushBeforeQuery(this.getActivePersistenceContext(foundTransaction));
    }

    public boolean shouldPropagatePersistenceContext() {
        return this.propagatePersistenceContext;
    }

    public boolean shouldBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void joinTransaction() {
        try {
            this.verifyOpen();
            this.transaction.registerUnitOfWorkWithTxn(this.getActivePersistenceContext(this.checkForTransaction(true)));
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setRollbackOnly() {
        this.transaction.setRollbackOnlyInternal();
    }

    private void setBeginEarlyTransaction() {
        String beginEarlyTransactionProperty = (String)this.getProperty("eclipselink.transaction.join-existing");
        if (beginEarlyTransactionProperty != null) {
            this.beginEarlyTransaction = "true".equalsIgnoreCase(beginEarlyTransactionProperty);
        }
    }

    protected void setEntityTransactionWrapper() {
        this.transaction = new EntityTransactionWrapper(this);
    }

    public void setFlushMode(FlushModeType flushMode) {
        try {
            this.verifyOpen();
            this.flushMode = flushMode;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void setJTATransactionWrapper() {
        this.transaction = new JTATransactionWrapper(this);
    }
}

