/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class MetadataHelper {
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";

    static Class getClassForName(String classname, ClassLoader loader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, loader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    static Object getClassInstance(Class cls) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(cls));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.errorInstantiatingClass(cls, exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(cls);
        }
        catch (IllegalAccessException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
        catch (InstantiationException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
    }

    static Object getClassInstance(String className, ClassLoader loader) {
        return MetadataHelper.getClassInstance(MetadataHelper.getClassForName(className, loader));
    }

    static Method[] getDeclaredMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods(cls);
    }

    static Field[] getFields(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredFields(cls);
    }

    public static String getName(String name, String defaultName, String context, MetadataLogger logger, String location) {
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return "";
        }
        logger.logConfigMessage(context, location, (Object)defaultName);
        return defaultName;
    }

    public static Integer getValue(Integer value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getValue(String value, String defaultValue) {
        if (value != null && !value.equals("")) {
            return value;
        }
        return defaultValue;
    }

    static boolean havePersistenceAnnotationsDefined(AnnotatedElement[] annotatedElements) {
        for (AnnotatedElement annotatedElement : annotatedElements) {
            for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith(PERSISTENCE_PACKAGE_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement) {
        for (Annotation declaredAnnotation : annotatedElement.getDeclaredAnnotations()) {
            if (!((Object)declaredAnnotation).toString().substring(1, ((Object)declaredAnnotation).toString().indexOf("(")).equalsIgnoreCase(annotation.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean valuesMatch(Object value1, Object value2) {
        if (value1 == null && value2 != null || value2 == null && value1 != null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        return value1.equals(value2);
    }
}

