/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.Table;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.InheritanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.SecondaryTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAccessor
extends MappedSuperclassAccessor {
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private InheritanceMetadata m_inheritance;
    private List<AssociationOverrideMetadata> m_associationOverrides;
    private List<AttributeOverrideMetadata> m_attributeOverrides;
    private List<NamedQueryMetadata> m_namedQueries;
    private List<NamedNativeQueryMetadata> m_namedNativeQueries;
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private List<SecondaryTableMetadata> m_secondaryTables;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private String m_discriminatorValue;
    private String m_entityName;
    private TableGeneratorMetadata m_tableGenerator;
    private TableMetadata m_table;

    public EntityAccessor() {
    }

    public EntityAccessor(Class cls, MetadataProject project) {
        super(cls, project);
    }

    protected void addMultipleTableKeyFields(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns, DatabaseTable sourceTable, DatabaseTable targetTable, String PK_CTX, String FK_CTX) {
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : this.processPrimaryKeyJoinColumns(primaryKeyJoinColumns)) {
            String defaultPKFieldName = this.getDescriptor().getPrimaryKeyFieldName();
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX));
            pkField.setTable(sourceTable);
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, pkField.getName(), FK_CTX));
            fkField.setTable(targetTable);
            this.getDescriptor().addForeignKeyFieldForMultipleTable(fkField, pkField);
        }
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public String getDiscriminatorValue() {
        return this.m_discriminatorValue;
    }

    public String getEntityName() {
        return this.m_entityName;
    }

    public InheritanceMetadata getInheritance() {
        return this.m_inheritance;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<SecondaryTableMetadata> getSecondaryTables() {
        return this.m_secondaryTables;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public TableMetadata getTable() {
        return this.m_table;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    protected boolean hasInheritance() {
        if (this.m_inheritance == null) {
            return this.isAnnotationPresent(Inheritance.class);
        }
        return true;
    }

    public boolean isInheritanceSubclass() {
        MetadataAccessor lastParent = null;
        for (Class parent = this.getJavaClass().getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
            EntityAccessor parentAccessor = this.getProject().getEntityAccessor(parent.getName());
            if (parentAccessor == null) continue;
            if (lastParent == null) {
                this.getDescriptor().setParentClass(parent);
            }
            lastParent = parentAccessor;
            if (parentAccessor.hasInheritance()) break;
        }
        if (lastParent == null) {
            return false;
        }
        this.getDescriptor().setInheritanceParentDescriptor(lastParent.getDescriptor());
        return true;
    }

    @Override
    public void process() {
        this.processEntity();
        this.processTableAndInheritance();
        this.processClassMetadata();
        this.processMappedSuperclasses();
        this.processAccessors();
        this.validatePrimaryKey();
        this.validateOptimisticLocking();
        this.processBasicCollectionAccessors();
        this.processSecondaryTables();
    }

    @Override
    protected void processAssociationOverrides() {
        if (this.m_associationOverrides != null) {
            for (AssociationOverrideMetadata associationOverride : this.m_associationOverrides) {
                associationOverride.setJavaClassName(this.getJavaClassName());
                associationOverride.setLocation(this.getEntityMappings().getMappingFileName());
                this.processAssociationOverride(associationOverride);
            }
        }
        super.processAssociationOverrides();
    }

    @Override
    protected void processAttributeOverrides() {
        if (this.m_attributeOverrides != null) {
            for (AttributeOverrideMetadata attributeOverride : this.m_attributeOverrides) {
                attributeOverride.setLocation(this.getEntityMappings().getMappingFileName());
                attributeOverride.setJavaClassName(this.getJavaClassName());
                attributeOverride.getColumn().setAttributeName(attributeOverride.getName());
                this.processAttributeOverride(attributeOverride);
            }
        }
        super.processAttributeOverrides();
    }

    protected void processDefaultListeners() {
        for (EntityListenerMetadata defaultListener : this.getProject().getDefaultListeners()) {
            EntityListenerMetadata listener = (EntityListenerMetadata)defaultListener.clone();
            listener.setEntityClass(this.getJavaClass());
            listener.initializeListenerClass(MetadataHelper.getClassForName(listener.getClassName(), this.getJavaClass().getClassLoader()));
            Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener);
            this.processCallbackMethodNames(candidateMethods, listener);
            this.processCallbackMethods(candidateMethods, listener);
            this.getDescriptor().addDefaultEventListener(listener);
        }
    }

    protected void processDiscriminatorValue() {
        if (!Modifier.isAbstract(this.getJavaClass().getModifiers())) {
            if (this.m_discriminatorValue == null) {
                Object discriminatorValue = this.getAnnotation(DiscriminatorValue.class);
                if (discriminatorValue == null) {
                    this.getDescriptor().addClassIndicator(this.getJavaClass(), Helper.getShortClassName(this.getJavaClassName()));
                } else {
                    this.getDescriptor().addClassIndicator(this.getJavaClass(), (String)MetadataHelper.invokeMethod("value", discriminatorValue));
                }
            } else {
                this.getDescriptor().addClassIndicator(this.getJavaClass(), this.m_discriminatorValue);
            }
        }
    }

    protected void processEntity() {
        if (this.getDescriptor().getAlias().equals("")) {
            ClassDescriptor existingDescriptor;
            Object entity;
            String alias = this.m_entityName == null ? ((entity = this.getAnnotation(Entity.class)) == null ? "" : (String)MetadataHelper.invokeMethod("name", entity)) : this.m_entityName;
            if (alias.equals("")) {
                alias = Helper.getShortClassName(this.getJavaClassName());
                this.getLogger().logConfigMessage("metadata_default_alias", this.getDescriptor(), (Object)alias);
            }
            if ((existingDescriptor = this.getProject().getSession().getProject().getDescriptorForAlias(alias)) != null) {
                throw ValidationException.nonUniqueEntityName(existingDescriptor.getJavaClassName(), this.getDescriptor().getJavaClassName(), alias);
            }
            this.getDescriptor().setAlias(alias);
            this.getProject().getSession().getProject().addAlias(alias, this.getDescriptor().getClassDescriptor());
        }
    }

    public EntityListenerMetadata processEntityEventListener() {
        EntityClassListenerMetadata listener = new EntityClassListenerMetadata(this);
        Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityClass(this.getJavaClass());
        this.processCallbackMethodNames(candidateMethods, listener);
        this.processCallbackMethods(candidateMethods, listener);
        return listener;
    }

    protected void processInheritance() {
        if (this.m_inheritance == null) {
            new InheritanceMetadata((Annotation)this.getAnnotation(Inheritance.class)).process(this.getDescriptor(), this.getJavaClass());
        } else {
            this.m_inheritance.process(this.getDescriptor(), this.getJavaClass());
        }
        if (this.m_discriminatorColumn == null) {
            this.getDescriptor().setClassIndicatorField(new DiscriminatorColumnMetadata((Annotation)this.getAnnotation(DiscriminatorColumn.class)).process(this.getDescriptor(), this.getAnnotatedElementName()));
        } else {
            this.getDescriptor().setClassIndicatorField(this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName()));
        }
        this.processDiscriminatorValue();
    }

    protected void processInheritanceSubclass(MetadataDescriptor parentDescriptor) {
        if (parentDescriptor.usesSingleTableInheritanceStrategy() && !this.hasInheritance()) {
            this.getDescriptor().setSingleTableInheritanceStrategy();
        } else {
            PrimaryKeyJoinColumnsMetadata pkJoinColumns;
            if (this.getPrimaryKeyJoinColumns() == null) {
                Object primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class);
                Object primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class);
                pkJoinColumns = new PrimaryKeyJoinColumnsMetadata((Annotation)primaryKeyJoinColumns, (Annotation)primaryKeyJoinColumn);
            } else {
                pkJoinColumns = new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns());
            }
            this.addMultipleTableKeyFields(pkJoinColumns, this.getDescriptor().getPrimaryKeyTable(), this.getDescriptor().getPrimaryTable(), "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column");
        }
        if (!this.hasInheritance()) {
            this.processDiscriminatorValue();
        }
        if (parentDescriptor.hasCompositePrimaryKey()) {
            this.getDescriptor().setPKClass(parentDescriptor.getPKClassName());
        }
    }

    public void processListeners(ClassLoader loader) {
        this.processDefaultListeners();
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            List<MappedSuperclassAccessor> mappedSuperclasses = this.getMappedSuperclasses();
            int mappedSuperclassesSize = mappedSuperclasses.size();
            for (int i = mappedSuperclassesSize - 1; i >= 0; --i) {
                mappedSuperclasses.get(i).processEntityListeners(this.getJavaClass());
            }
        }
        this.processEntityListeners(this.getJavaClass());
        EntityListenerMetadata listener = this.processEntityEventListener();
        if (!this.getDescriptor().excludeSuperclassListeners()) {
            for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
                mappedSuperclass.processEntityEventListener(listener, this.getJavaClass(), loader);
            }
        }
        if (listener.hasCallbackMethods()) {
            this.getDescriptor().setEntityEventListener(listener);
        }
    }

    protected void processMappedSuperclasses() {
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            mappedSuperclass.process();
        }
    }

    @Override
    protected void processNamedNativeQueries() {
        if (this.m_namedNativeQueries != null) {
            this.getEntityMappings().processNamedNativeQueries(this.m_namedNativeQueries, this.getJavaClassName());
        }
        super.processNamedNativeQueries();
    }

    @Override
    protected void processNamedQueries() {
        if (this.m_namedQueries != null) {
            this.getEntityMappings().processNamedQueries(this.m_namedQueries, this.getJavaClassName());
        }
        super.processNamedQueries();
    }

    @Override
    protected void processNamedStoredProcedureQueries() {
        if (this.m_namedStoredProcedureQueries != null) {
            this.getEntityMappings().processNamedStoredProcedureQueries(this.m_namedStoredProcedureQueries, this.getJavaClassName());
        }
        super.processNamedStoredProcedureQueries();
    }

    protected void processSecondaryTable(SecondaryTableMetadata secondaryTable) {
        this.processTable(secondaryTable, secondaryTable.getName());
        this.getDescriptor().addTable(secondaryTable.getDatabaseTable());
        this.addMultipleTableKeyFields(new PrimaryKeyJoinColumnsMetadata(secondaryTable.getPrimaryKeyJoinColumns()), this.getDescriptor().getPrimaryTable(), secondaryTable.getDatabaseTable(), "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column");
    }

    protected void processSecondaryTables() {
        block5: {
            block3: {
                block4: {
                    if (this.m_secondaryTables != null && !this.m_secondaryTables.isEmpty()) break block3;
                    Object secondaryTables = this.getAnnotation(SecondaryTables.class);
                    if (secondaryTables == null) break block4;
                    for (Annotation secondaryTable : (Annotation[])MetadataHelper.invokeMethod("value", secondaryTables)) {
                        this.processSecondaryTable(new SecondaryTableMetadata(secondaryTable, this.getJavaClassName()));
                    }
                    break block5;
                }
                Object secondaryTable = this.getAnnotation(SecondaryTable.class);
                if (secondaryTable == null) break block5;
                this.processSecondaryTable(new SecondaryTableMetadata((Annotation)secondaryTable, this.getJavaClassName()));
                break block5;
            }
            if (this.isAnnotationPresent(SecondaryTables.class) || this.isAnnotationPresent(SecondaryTable.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_secondary_table", this.getJavaClass());
            }
            for (SecondaryTableMetadata secondaryTable : this.m_secondaryTables) {
                secondaryTable.setLocation(this.getJavaClassName());
                this.processSecondaryTable(secondaryTable);
            }
        }
    }

    @Override
    protected void processSequenceGenerator() {
        if (this.m_sequenceGenerator != null) {
            this.getEntityMappings().processSequenceGenerator(this.m_sequenceGenerator, this.getJavaClassName());
        }
        super.processSequenceGenerator();
    }

    @Override
    protected void processSqlResultSetMappings() {
        if (this.m_sqlResultSetMappings != null) {
            this.getEntityMappings().processSqlResultSetMappings(this.m_sqlResultSetMappings);
        }
        super.processSqlResultSetMappings();
    }

    protected void processTable() {
        if (this.m_table == null) {
            Object table = this.getAnnotation(Table.class);
            this.processTable(new TableMetadata((Annotation)table, this.getJavaClassName()));
        } else {
            if (this.isAnnotationPresent(Table.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_table", this.getJavaClass());
            }
            this.m_table.setLocation(this.getJavaClassName());
            this.processTable(this.m_table);
        }
    }

    protected void processTable(TableMetadata table) {
        this.processTable(table, this.getDescriptor().getDefaultTableName());
        this.getDescriptor().setPrimaryTable(table.getDatabaseTable());
    }

    protected void processTableAndInheritance() {
        if (this.isInheritanceSubclass()) {
            MetadataDescriptor parentDescriptor = this.getDescriptor().getInheritanceParentDescriptor();
            EntityAccessor parentAccessor = (EntityAccessor)parentDescriptor.getClassAccessor();
            if (!parentAccessor.isProcessed()) {
                parentAccessor.process();
                parentAccessor.setIsProcessed();
            }
            if (!parentAccessor.hasInheritance()) {
                parentAccessor.processInheritance();
            }
            if (this.hasInheritance()) {
                this.processTable();
                this.processInheritance();
                this.processInheritanceSubclass(parentDescriptor);
            } else {
                if (parentDescriptor.usesJoinedInheritanceStrategy()) {
                    this.processTable();
                }
                this.processInheritanceSubclass(parentDescriptor);
            }
        } else {
            this.processTable();
            if (this.hasInheritance()) {
                this.processInheritance();
            }
        }
    }

    @Override
    protected void processTableGenerator() {
        if (this.m_tableGenerator != null) {
            this.getEntityMappings().processTableGenerator(this.m_tableGenerator, this.getDescriptor().getXMLCatalog(), this.getDescriptor().getXMLSchema(), this.getJavaClassName());
        }
        super.processTableGenerator();
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        this.m_associationOverrides = associationOverrides;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.m_discriminatorValue = discriminatorValue;
    }

    public void setEntityName(String entityName) {
        this.m_entityName = entityName;
    }

    public void setInheritance(InheritanceMetadata inheritance) {
        this.m_inheritance = inheritance;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        this.m_namedNativeQueries = namedNativeQueries;
    }

    public void setNamedQueries(List<NamedQueryMetadata> namedQueries) {
        this.m_namedQueries = namedQueries;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries) {
        this.m_namedStoredProcedureQueries = namedStoredProcedureQueries;
    }

    public void setSecondaryTables(List<SecondaryTableMetadata> secondaryTables) {
        this.m_secondaryTables = secondaryTables;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        this.m_sequenceGenerator = sequenceGenerator;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        this.m_sqlResultSetMappings = sqlResultSetMappings;
    }

    public void setTable(TableMetadata table) {
        this.m_table = table;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGenerator) {
        this.m_tableGenerator = tableGenerator;
    }

    protected void validateOptimisticLocking() {
        if (this.getDescriptor().usesVersionColumnOptimisticLocking() && !this.getDescriptor().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingVersionElementNotSpecified(this.getJavaClass());
        }
    }

    protected void validatePrimaryKey() {
        if (this.getDescriptor().hasCompositePrimaryKey()) {
            if (this.getDescriptor().pkClassWasNotValidated()) {
                throw ValidationException.invalidCompositePKSpecification(this.getJavaClass(), this.getDescriptor().getPKClassName());
            }
        } else if (!this.getDescriptor().hasPrimaryKeyFields() && !this.getDescriptor().isInheritanceSubclass()) {
            throw ValidationException.noPrimaryKeyAnnotationsFound(this.getJavaClass());
        }
    }
}

