/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethods;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetMethods;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MetadataHelper {
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";

    static Method[] getCandidateCallbackMethodsForEntityClass(Class entityClass) {
        return MetadataHelper.getDeclaredMethods(entityClass);
    }

    static Method[] getCandidateCallbackMethodsForEntityListener(EntityListenerMetadata listener) {
        HashSet<Method> candidateMethods = new HashSet<Method>();
        Class listenerClass = listener.getListenerClass();
        Method[] declaredMethods = MetadataHelper.getDeclaredMethods(listenerClass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            candidateMethods.add(declaredMethods[i]);
        }
        Method[] methods = MetadataHelper.getMethods(listenerClass);
        for (int i = 0; i < methods.length; ++i) {
            if (candidateMethods.contains(methods[i])) continue;
            candidateMethods.add(methods[i]);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    static Method[] getCandidateCallbackMethodsForMappedSuperclass(Class mappedSuperclass, Class entityClass) {
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] allMethods = MetadataHelper.getMethods(entityClass);
        Method[] declaredMethods = MetadataHelper.getDeclaredMethods(mappedSuperclass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = MetadataHelper.getMethodForName(allMethods, declaredMethods[i].getName());
            if (method == null) continue;
            candidateMethods.add(method);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    static Class getClassForName(String classname, ClassLoader loader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, loader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    static int getDeclaredAnnotationsCount(AnnotatedElement annotatedElement, MetadataDescriptor descriptor) {
        if (descriptor.ignoreAnnotations()) {
            return 0;
        }
        int count = 0;
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getName().startsWith(PERSISTENCE_PACKAGE_PREFIX)) continue;
            ++count;
        }
        return count;
    }

    static Method[] getDeclaredMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetDeclaredMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredMethods(cls);
    }

    static Field[] getFields(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredFields(cls);
    }

    static Method getMethod(String methodName, Class cls, Class[] params) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(cls, methodName, params, true));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod(cls, methodName, params, true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    static Method getMethodForName(Method[] methods, String methodName) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    static Method[] getMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethods(cls);
    }

    static Object invokeMethod(String methodName, Object target) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(target.getClass(), methodName);
        }
        catch (NoSuchMethodException e) {
            EntityManagerSetupException.methodInvocationFailed(method, target, e);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, target));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, target, throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, target);
            }
            catch (IllegalAccessException ex1) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
            }
            catch (InvocationTargetException ex2) {
                throw EntityManagerSetupException.methodInvocationFailed(method, target, ex2);
            }
        }
        return null;
    }
}

