/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.sql.Blob;
import java.util.Collection;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Mutable;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public class BasicAccessor
extends DirectAccessor {
    private Boolean m_mutable;
    private ColumnMetadata m_column;
    private DatabaseField m_field;

    public BasicAccessor() {
    }

    public BasicAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object basic = this.getAnnotation(Basic.class);
        if (basic != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", basic));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", basic));
        }
        this.m_column = new ColumnMetadata((Annotation)this.getAnnotation(Column.class), this.getAttributeName());
        Object mutable = this.getAnnotation(Mutable.class);
        if (mutable != null) {
            this.m_mutable = (Boolean)MetadataHelper.invokeMethod("value", mutable);
        }
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        if (this.m_column == null) {
            return new ColumnMetadata(this.getAttributeName());
        }
        return this.m_column;
    }

    public FetchType getDefaultFetchType() {
        return FetchType.EAGER;
    }

    protected DatabaseField getField() {
        return this.m_field;
    }

    public Boolean getMutable() {
        return this.m_mutable;
    }

    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.m_column != null) {
            this.m_column.setAttributeName(this.getAttributeName());
        }
    }

    protected boolean isCollectionClass(Class cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    protected boolean isMapClass(Class cls) {
        return Map.class.isAssignableFrom(cls);
    }

    public void process() {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        this.m_field = this.getDatabaseField(this.getDescriptor().getPrimaryTable(), "metadata_default_column");
        mapping.setField(this.m_field);
        mapping.setIsReadOnly(this.m_field.isReadOnly());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        this.setAccessorMethods(mapping);
        this.processMappingConverter(mapping);
        if (this.m_mutable != null) {
            mapping.setIsMutable(this.m_mutable);
        }
        this.processReturnInsert(this.m_field);
        this.processReturnUpdate(this.m_field);
        this.processProperties(mapping);
        this.getDescriptor().addMapping(mapping);
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        if (this.isCollectionClass(this.getReferenceClass()) || this.isMapClass(this.getReferenceClass())) {
            this.processSerialized(mapping);
        } else {
            super.processEnumerated(mapping);
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (this.isCollectionClass(this.getReferenceClass()) || this.isMapClass(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.processSerialized(mapping);
        } else {
            super.processLob(mapping);
        }
    }

    protected void processReturnInsert(DatabaseField field) {
        Object returnInsert = this.getAnnotation(ReturnInsert.class);
        if (returnInsert != null) {
            this.processReturnInsert(field, (Boolean)MetadataHelper.invokeMethod("returnOnly", returnInsert));
        }
    }

    protected void processReturnInsert(DatabaseField field, boolean returnOnly) {
        if (returnOnly) {
            this.getDescriptor().addFieldForInsertReturnOnly(field);
        } else {
            this.getDescriptor().addFieldForInsert(field);
        }
    }

    protected void processReturnUpdate(DatabaseField field) {
        if (this.hasReturnUpdate()) {
            this.getDescriptor().addFieldForUpdate(field);
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setConverter(DatabaseMapping mapping, Converter converter) {
        ((DirectToFieldMapping)mapping).setConverter(converter);
    }

    public void setConverterClassName(DatabaseMapping mapping, String converterClassName) {
        ((DirectToFieldMapping)mapping).setConverterClassName(converterClassName);
    }

    public void setFieldClassification(DatabaseMapping mapping, Class classification) {
        ((DirectToFieldMapping)mapping).setFieldClassification(classification);
    }

    public void setMutable(Boolean mutable) {
        this.m_mutable = mutable;
    }
}

