/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ClassInstanceConverter;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public abstract class DirectAccessor
extends MetadataAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String CONVERT_CLASS_INSTANCE = "class-instance";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private Boolean m_lob;
    private Boolean m_optional;
    private Enum m_fetch;
    private Enum m_enumerated;
    private Enum m_temporal;
    private String m_convert;

    protected DirectAccessor() {
    }

    protected DirectAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object convert;
        Object temporal;
        Object enumerated;
        if (this.isAnnotationPresent(Lob.class)) {
            this.m_lob = new Boolean(true);
        }
        if ((enumerated = this.getAnnotation(Enumerated.class)) != null) {
            this.m_enumerated = (Enum)MetadataHelper.invokeMethod("value", enumerated);
        }
        if ((temporal = this.getAnnotation(Temporal.class)) != null) {
            this.m_temporal = (Enum)MetadataHelper.invokeMethod("value", temporal);
        }
        if ((convert = this.getAnnotation(Convert.class)) != null) {
            this.m_convert = (String)MetadataHelper.invokeMethod("value", convert);
        }
    }

    protected abstract ColumnMetadata getColumn(String var1);

    public String getConvert() {
        return this.m_convert;
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        ColumnMetadata column = this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName()) && !loggingCtx.equals("metadata_default_key_column") ? this.getDescriptor().getAttributeOverrideFor(this.getAttributeName()).getColumn() : this.getColumn(loggingCtx);
        DatabaseField field = column.getDatabaseField();
        if (field.getTableName().equals("")) {
            field.setTable(defaultTable);
        }
        String defaultName = column.getUpperCaseAttributeName();
        if (loggingCtx.equals("metadata_default_key_column")) {
            defaultName = defaultName + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        field.setName(this.getName(field.getName(), defaultName, loggingCtx));
        return field;
    }

    public abstract FetchType getDefaultFetchType();

    public Enum getEnumerated() {
        return this.m_enumerated;
    }

    public Enum getFetch() {
        return this.m_fetch;
    }

    protected Class getFieldClassification(Enum type) {
        if (type.equals(TemporalType.DATE)) {
            return Date.class;
        }
        if (type.equals(TemporalType.TIME)) {
            return Time.class;
        }
        if (type.equals(TemporalType.TIMESTAMP)) {
            return Timestamp.class;
        }
        return null;
    }

    public Boolean getLob() {
        return this.m_lob;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public Enum getTemporal() {
        return this.m_temporal;
    }

    protected boolean hasConvert() {
        return this.m_convert != null;
    }

    public boolean isEnumerated() {
        if (this.hasConvert()) {
            if (this.m_enumerated != null) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.m_enumerated != null || this.isValidEnumeratedType(this.getReferenceClass());
    }

    public boolean isLob() {
        if (this.hasConvert()) {
            if (this.m_lob != null) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.m_lob != null;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isOptional() {
        if (this.m_optional == null) {
            return true;
        }
        return this.m_optional;
    }

    protected boolean isPrimitiveWrapperClass(Class cls) {
        return Long.class.isAssignableFrom(cls) || Short.class.isAssignableFrom(cls) || Float.class.isAssignableFrom(cls) || Byte.class.isAssignableFrom(cls) || Double.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls) || Integer.class.isAssignableFrom(cls) || Character.class.isAssignableFrom(cls) || String.class.isAssignableFrom(cls) || BigInteger.class.isAssignableFrom(cls) || BigDecimal.class.isAssignableFrom(cls) || java.util.Date.class.isAssignableFrom(cls) || Calendar.class.isAssignableFrom(cls);
    }

    public boolean isSerialized() {
        if (this.hasConvert()) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_serialized", this.getJavaClass(), this.getAnnotatedElement());
            return false;
        }
        return this.isValidSerializedType(this.getReferenceClass());
    }

    public boolean isTemporal() {
        if (this.hasConvert()) {
            if (this.m_temporal != null) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.m_temporal != null || this.isValidTemporalType(this.getReferenceClass());
    }

    protected boolean isValidBlobType(Class cls) {
        return cls.equals(byte[].class) || cls.equals(Byte[].class) || cls.equals(Blob.class);
    }

    protected boolean isValidClobType(Class cls) {
        return cls.equals(char[].class) || cls.equals(String.class) || cls.equals(Character[].class) || cls.equals(Clob.class);
    }

    protected boolean isValidLobType(Class cls) {
        return this.isValidClobType(cls) || this.isValidBlobType(cls);
    }

    protected boolean isValidEnumeratedType(Class cls) {
        return cls.isEnum();
    }

    protected boolean isValidSerializedType(Class cls) {
        if (cls.isPrimitive()) {
            return false;
        }
        if (this.isPrimitiveWrapperClass(cls)) {
            return false;
        }
        if (this.isValidLobType(cls)) {
            return false;
        }
        return !this.isValidTemporalType(cls);
    }

    protected boolean isValidTemporalType(Class cls) {
        return cls.equals(java.util.Date.class) || cls.equals(Calendar.class) || cls.equals(GregorianCalendar.class);
    }

    protected void processClassInstance(DatabaseMapping mapping) {
        ClassInstanceConverter converter = new ClassInstanceConverter();
        this.setConverter(mapping, converter);
    }

    public void processConvert() {
        this.processConvert(this.getDescriptor().getMappingForAttributeName(this.getAttributeName()), this.m_convert);
    }

    protected void processConvert(DatabaseMapping mapping, String converterName) {
        if (!converterName.equals(CONVERT_NONE)) {
            if (converterName.equals(CONVERT_SERIALIZED)) {
                this.processSerialized(mapping);
            } else if (converterName.equals(CONVERT_CLASS_INSTANCE)) {
                this.processClassInstance(mapping);
            } else {
                AbstractConverterMetadata converter = this.getProject().getConverter(converterName);
                if (converter == null) {
                    StructConverterMetadata structConverter = this.getProject().getStructConverter(converterName);
                    if (structConverter == null) {
                        throw ValidationException.converterNotFound(this.getJavaClass(), converterName, this.getAnnotatedElement());
                    }
                    structConverter.process(mapping, this);
                } else {
                    converter.process(mapping, this);
                }
            }
        }
    }

    protected void processEnumerated(DatabaseMapping mapping) {
        if (this.m_enumerated != null && !this.isValidEnumeratedType(this.getReferenceClass())) {
            throw ValidationException.invalidTypeForEnumeratedAttribute(mapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        if (this.m_enumerated == null) {
            this.setConverter(mapping, new EnumTypeConverter(mapping, this.getReferenceClass(), true));
        } else {
            this.setConverter(mapping, new EnumTypeConverter(mapping, this.getReferenceClass(), this.m_enumerated.equals(EnumType.ORDINAL)));
        }
    }

    protected void processJPAConverters(DatabaseMapping mapping) {
        if (this.isEnumerated()) {
            this.processEnumerated(mapping);
        } else if (this.isLob()) {
            this.processLob(mapping);
        } else if (this.isTemporal()) {
            this.processTemporal(mapping);
        } else if (this.isSerialized()) {
            this.processSerialized(mapping);
        }
    }

    protected void processLob(DatabaseMapping mapping) {
        if (this.isValidClobType(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Clob.class);
            this.setConverter(mapping, new TypeConversionConverter(mapping));
        } else if (this.isValidBlobType(this.getReferenceClass())) {
            this.setFieldClassification(mapping, Blob.class);
            this.setConverter(mapping, new TypeConversionConverter(mapping));
        } else if (Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            this.setFieldClassification(mapping, Blob.class);
            this.setConverter(mapping, new SerializedObjectConverter(mapping));
        } else {
            throw ValidationException.invalidTypeForLOBAttribute(mapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
    }

    protected void processMappingConverter(DatabaseMapping mapping) {
        if (this.m_convert == null) {
            this.processJPAConverters(mapping);
        } else {
            this.processMappingConverter(mapping, this.m_convert);
        }
    }

    protected void processMappingConverter(DatabaseMapping mapping, String convertValue) {
        if (convertValue != null && !convertValue.equals(CONVERT_NONE)) {
            this.getProject().addConvertAccessor(this);
        }
        this.processJPAConverters(mapping);
    }

    protected void processSerialized(DatabaseMapping mapping) {
        if (!Helper.classImplementsInterface(this.getReferenceClass(), Serializable.class)) {
            throw ValidationException.invalidTypeForSerializedAttribute(mapping.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        SerializedObjectConverter converter = new SerializedObjectConverter(mapping);
        this.setConverter(mapping, converter);
    }

    protected void processTemporal(DatabaseMapping mapping) {
        if (this.m_temporal == null) {
            throw ValidationException.noTemporalTypeSpecified(this.getAttributeName(), this.getJavaClass());
        }
        if (this.isValidTemporalType(this.getReferenceClass())) {
            if (this.m_temporal.equals(TemporalType.DATE)) {
                this.setFieldClassification(mapping, Date.class);
            } else if (this.m_temporal.equals(TemporalType.TIME)) {
                this.setFieldClassification(mapping, Time.class);
            } else {
                this.setFieldClassification(mapping, Timestamp.class);
            }
        } else {
            throw ValidationException.invalidTypeForTemporalAttribute(this.getAttributeName(), this.getReferenceClass(), this.getJavaClass());
        }
        this.setConverter(mapping, new TypeConversionConverter(mapping));
    }

    public void setConvert(String convert) {
        this.m_convert = convert;
    }

    public abstract void setConverter(DatabaseMapping var1, Converter var2);

    public abstract void setConverterClassName(DatabaseMapping var1, String var2);

    public void setEnumerated(Enum enumerated) {
        this.m_enumerated = enumerated;
    }

    public void setFetch(Enum fetch) {
        this.m_fetch = fetch;
    }

    public abstract void setFieldClassification(DatabaseMapping var1, Class var2);

    public void setLob(Boolean lob) {
        this.m_lob = lob;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setTemporal(Enum temporalType) {
        this.m_temporal = temporalType;
    }

    public boolean usesIndirection() {
        Enum fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY);
    }
}

