/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embeddable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAccessor
extends MetadataAccessor {
    private List<AttributeOverrideMetadata> m_attributeOverrides;

    public EmbeddedAccessor() {
    }

    public EmbeddedAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object attributeOverride;
        this.m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        Object attributeOverrides = this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null) {
            for (Annotation attributeOverride2 : (Annotation[])MetadataHelper.invokeMethod("value", attributeOverrides)) {
                this.m_attributeOverrides.add(new AttributeOverrideMetadata(attributeOverride2, this.getJavaClassName()));
            }
        }
        if ((attributeOverride = this.getAnnotation(AttributeOverride.class)) != null) {
            this.m_attributeOverrides.add(new AttributeOverrideMetadata((Annotation)attributeOverride, this.getJavaClassName()));
        }
    }

    protected AccessType getAccessTypeFromAnnotation(MetadataDescriptor descriptor) {
        boolean fieldAccess = MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getFields(descriptor.getJavaClass()));
        boolean propertyAccess = MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getMethods(descriptor.getJavaClass()));
        if (fieldAccess && propertyAccess) {
            return AccessType.MIXED;
        }
        if (fieldAccess) {
            return AccessType.FIELD;
        }
        if (propertyAccess) {
            return AccessType.PROPERTY;
        }
        return AccessType.UNDEFINED;
    }

    protected AccessType getAccessTypeOfEmbeddable(EmbeddableAccessor accessor) {
        AccessType xmlAccessType;
        AccessType accessType = AccessType.UNDEFINED;
        AccessType entityAccessType = this.getOwningDescriptor().usesPropertyAccess() ? AccessType.PROPERTY : AccessType.FIELD;
        AccessType accessType2 = xmlAccessType = accessor.getDescriptor().getXMLAccess() == null ? AccessType.UNDEFINED : AccessType.valueOf(accessor.getDescriptor().getXMLAccess());
        if (accessor.getDescriptor().ignoreAnnotations()) {
            accessType = xmlAccessType == AccessType.UNDEFINED ? entityAccessType : xmlAccessType;
        } else {
            AccessType annotationAccessType = this.getAccessTypeFromAnnotation(accessor.getDescriptor());
            if (annotationAccessType == AccessType.UNDEFINED && xmlAccessType == AccessType.UNDEFINED) {
                accessType = entityAccessType;
            } else if (xmlAccessType == AccessType.UNDEFINED && annotationAccessType != AccessType.UNDEFINED) {
                accessType = annotationAccessType;
                if (accessType == AccessType.MIXED) {
                    throw ValidationException.bothFieldsAndPropertiesAnnotated(accessor.getJavaClass());
                }
            } else if (annotationAccessType == AccessType.UNDEFINED && xmlAccessType != AccessType.UNDEFINED) {
                accessType = xmlAccessType;
            } else if (annotationAccessType == xmlAccessType) {
                accessType = annotationAccessType;
            } else {
                throw ValidationException.incorrectOverridingOfAccessType(accessor.getJavaClass(), xmlAccessType.toString(), annotationAccessType.toString());
            }
        }
        return accessType;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    @Override
    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        for (AttributeOverrideMetadata attributeOverride : this.m_attributeOverrides) {
            attributeOverride.getColumn().setAttributeName(attributeOverride.getName());
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    protected boolean isMetadataPresent(EmbeddableAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        AccessType annotationAccessType = this.getAccessTypeFromAnnotation(descriptor);
        AccessType xmlAccessType = descriptor.getXMLAccess() == null ? AccessType.UNDEFINED : AccessType.valueOf(descriptor.getXMLAccess());
        return annotationAccessType != AccessType.UNDEFINED || xmlAccessType != AccessType.UNDEFINED;
    }

    @Override
    public void process() {
        this.processEmbeddableClass();
        AggregateObjectMapping mapping = new AggregateObjectMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsNullAllowed(true);
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(mapping);
        for (AttributeOverrideMetadata attributeOverride : this.m_attributeOverrides) {
            this.processAttributeOverride(mapping, attributeOverride);
        }
        this.processAssociationOverrides(mapping);
        this.processProperties(mapping);
        this.processReturnInsertAndUpdate();
        this.getDescriptor().addEmbeddableDescriptor(this.getReferenceDescriptor());
        this.getDescriptor().addMapping(mapping);
    }

    protected void processAssociationOverride(Object associationOverride, AggregateObjectMapping aggregateMapping) {
        String name;
        MetadataDescriptor aggregateDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = aggregateDescriptor.getMappingForAttributeName(name = (String)MetadataHelper.invokeMethod("name", associationOverride));
        if (mapping != null && mapping.isOneToOneMapping()) {
            int index = 0;
            for (Annotation joinColumn : (Annotation[])MetadataHelper.invokeMethod("joinColumns", associationOverride)) {
                DatabaseField fkField = ((OneToOneMapping)mapping).getForeignKeyFields().elementAt(index++);
                aggregateMapping.addFieldNameTranslation((String)MetadataHelper.invokeMethod("name", joinColumn), fkField.getName());
            }
        }
    }

    protected void processAssociationOverrides(AggregateObjectMapping mapping) {
        Object associationOverride;
        Object associationOverrides = this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (Annotation associationOverride2 : (Annotation[])MetadataHelper.invokeMethod("value", associationOverrides)) {
                this.processAssociationOverride(associationOverride2, mapping);
            }
        }
        if ((associationOverride = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(associationOverride, mapping);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, AttributeOverrideMetadata attributeOverride) {
        DatabaseField overrideField;
        String attributeName = attributeOverride.getName();
        DatabaseMapping aggregateMapping = this.getReferenceDescriptor().getMappingForAttributeName(attributeName);
        if (aggregateMapping == null) {
            throw ValidationException.invalidEmbeddableAttribute(this.getReferenceDescriptor().getJavaClass(), attributeName, this.getJavaClass(), mapping.getAttributeName());
        }
        if (this.getDescriptor().hasAttributeOverrideFor(attributeName)) {
            attributeOverride.getColumn().setDatabaseField(this.getDescriptor().getAttributeOverrideFor(attributeName).getColumn().getDatabaseField());
        }
        if ((overrideField = attributeOverride.getColumn().getDatabaseField()).getTableName().equals("")) {
            overrideField.setTable(this.getOwningDescriptor().getPrimaryTable());
        }
        DatabaseField aggregateField = aggregateMapping.getField();
        if (this.getOwningDescriptor().getPrimaryKeyFields().contains(aggregateField)) {
            this.getOwningDescriptor().getPrimaryKeyFields().remove(aggregateField);
            this.getOwningDescriptor().addPrimaryKeyField(overrideField);
        }
        mapping.addFieldNameTranslation(overrideField.getQualifiedName(), aggregateField.getName());
    }

    protected void processEmbeddableClass() {
        EmbeddableAccessor accessor = this.getProject().getEmbeddableAccessor(this.getReferenceClassName());
        if (accessor == null) {
            if (this.isAnnotationNotPresent(Embeddable.class, this.getReferenceClass())) {
                throw ValidationException.invalidEmbeddedAttribute(this.getJavaClass(), this.getAttributeName(), this.getReferenceClass());
            }
            accessor = new EmbeddableAccessor(this.getReferenceClass(), this.getProject());
            this.getProject().addEmbeddableAccessor(accessor);
        }
        accessor.setOwningDescriptor(this.getOwningDescriptor());
        if (!accessor.isProcessed()) {
            accessor.getDescriptor().setUsesPropertyAccess(this.getAccessTypeOfEmbeddable(accessor) == AccessType.PROPERTY);
            accessor.process();
            accessor.setIsProcessed();
        }
        if (!this.isMetadataPresent(accessor) && accessor.getDescriptor().usesPropertyAccess() != this.getOwningDescriptor().usesPropertyAccess()) {
            throw ValidationException.conflictingAccessTypeForEmbeddable(accessor.getJavaClass(), accessor.getDescriptor().usesPropertyAccess(), this.getOwningDescriptor().getJavaClass(), this.getOwningDescriptor().usesPropertyAccess());
        }
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        this.m_attributeOverrides = attributeOverrides;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessType {
        FIELD,
        PROPERTY,
        UNDEFINED,
        MIXED;

    }
}

