/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.Transformation;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.WriteTransformerMetadata;
import org.eclipse.persistence.mappings.TransformationMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationAccessor
extends BasicAccessor {
    private ReadTransformerMetadata m_readTransformer;
    private List<WriteTransformerMetadata> m_writeTransformers = new ArrayList<WriteTransformerMetadata>();

    public TransformationAccessor() {
    }

    public TransformationAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        WriteTransformers writeTransformers;
        WriteTransformer writeTransformer;
        ReadTransformer readTransformer;
        Transformation transformation = (Transformation)this.getAnnotation(Transformation.class);
        if (transformation != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", transformation));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", transformation));
        }
        if ((readTransformer = (ReadTransformer)this.getAnnotation(ReadTransformer.class)) != null) {
            this.setReadTransformer(readTransformer);
        }
        if ((writeTransformer = (WriteTransformer)this.getAnnotation(WriteTransformer.class)) != null) {
            this.addWriteTransformer(writeTransformer);
        }
        if ((writeTransformers = (WriteTransformers)this.getAnnotation(WriteTransformers.class)) != null) {
            WriteTransformer[] writeTransformerArray = writeTransformers.value();
            for (int i = 0; i < writeTransformerArray.length; ++i) {
                this.addWriteTransformer(writeTransformerArray[i]);
            }
        }
    }

    public ReadTransformerMetadata getReadTransformer() {
        return this.m_readTransformer;
    }

    public List<WriteTransformerMetadata> getWriteTransformers() {
        return this.m_writeTransformers;
    }

    @Override
    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.m_readTransformer != null && this.m_readTransformer.hasClassName()) {
            this.m_readTransformer.setTransformerClass(this.getEntityMappings().getClassForName(this.m_readTransformer.getTransformerClassName()));
        }
        for (WriteTransformerMetadata writeTransformer : this.m_writeTransformers) {
            writeTransformer.setTransformerClass(this.getEntityMappings().getClassForName(writeTransformer.getTransformerClassName()));
        }
    }

    @Override
    public void process() {
        TransformationMapping mapping = new TransformationMapping();
        mapping.setAttributeName(this.getAttributeName());
        mapping.setIsOptional(this.isOptional());
        mapping.setIsLazy(this.usesIndirection());
        if (this.getMutable() != null) {
            mapping.setIsMutable(this.getMutable());
        }
        this.setAccessorMethods(mapping);
        this.processProperties(mapping);
        this.getDescriptor().addMapping(mapping);
        if (this.m_readTransformer != null) {
            this.m_readTransformer.process(mapping);
        }
        if (this.m_writeTransformers.isEmpty()) {
            mapping.setIsReadOnly(true);
        } else {
            if (this.m_writeTransformers.size() == 1 && !this.m_writeTransformers.get(0).hasFieldName()) {
                this.m_writeTransformers.get(0).setFieldName(this.getAttributeName());
            }
            Iterator<WriteTransformerMetadata> it = this.m_writeTransformers.iterator();
            while (it.hasNext()) {
                it.next().process(mapping);
            }
        }
    }

    public void setReadTransformer(ReadTransformerMetadata readTransformer) {
        this.m_readTransformer = readTransformer;
    }

    public void setWriteTransformers(List<WriteTransformerMetadata> writeTransformers) {
        this.m_writeTransformers = writeTransformers;
    }

    protected void setReadTransformer(ReadTransformer readTransformer) {
        this.m_readTransformer = new ReadTransformerMetadata();
        this.m_readTransformer.setTransformerClass((Class)MetadataHelper.invokeMethod("transformerClass", readTransformer));
        this.m_readTransformer.setMethod((String)MetadataHelper.invokeMethod("method", readTransformer));
    }

    protected void addWriteTransformer(WriteTransformer writeTransformer) {
        WriteTransformerMetadata writeTransformerMetadata = new WriteTransformerMetadata();
        writeTransformerMetadata.setTransformerClass((Class)MetadataHelper.invokeMethod("transformerClass", writeTransformer));
        writeTransformerMetadata.setMethod((String)MetadataHelper.invokeMethod("method", writeTransformer));
        writeTransformerMetadata.setColumn(new ColumnMetadata((Annotation)((Column)MetadataHelper.invokeMethod("column", writeTransformer))));
        this.m_writeTransformers.add(writeTransformerMetadata);
    }
}

