/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;

public class DiscriminatorColumnMetadata {
    private Enum m_discriminatorType;
    private Integer m_length;
    private String m_columnDefinition;
    private String m_name;

    public DiscriminatorColumnMetadata() {
    }

    public DiscriminatorColumnMetadata(Annotation discriminatorColumn) {
        if (discriminatorColumn != null) {
            this.m_columnDefinition = (String)this.invokeMethod("columnDefinition", discriminatorColumn);
            this.m_discriminatorType = (Enum)this.invokeMethod("discriminatorType", discriminatorColumn);
            this.m_length = (Integer)this.invokeMethod("length", discriminatorColumn);
            this.m_name = (String)this.invokeMethod("name", discriminatorColumn);
        }
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public Enum getDiscriminatorType() {
        return this.m_discriminatorType;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    protected Object invokeMethod(String methodName, Annotation annotation) {
        return org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper.invokeMethod(methodName, annotation);
    }

    public DatabaseField process(MetadataDescriptor descriptor, String annotatedElementName) {
        DatabaseField field = new DatabaseField();
        field.setName(MetadataHelper.getName(this.m_name, "DTYPE", "metadata_default_discriminator_column", descriptor.getLogger(), annotatedElementName));
        field.setLength(MetadataHelper.getValue(this.m_length, 31));
        field.setColumnDefinition(MetadataHelper.getValue(this.m_columnDefinition, ""));
        if (this.m_discriminatorType == null || this.m_discriminatorType.equals(DiscriminatorType.STRING)) {
            field.setType(String.class);
        } else if (this.m_discriminatorType.equals(DiscriminatorType.CHAR)) {
            field.setType(Character.class);
        } else {
            field.setType(Integer.class);
        }
        field.setTable(descriptor.getPrimaryTable());
        return field;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setDiscriminatorType(Enum descriminatorType) {
        this.m_discriminatorType = descriminatorType;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

