/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class StructConverterMetadata
extends AbstractConverterMetadata {
    private String m_converter;

    public StructConverterMetadata() {
        this.setLoadedFromXML();
    }

    public StructConverterMetadata(Annotation converter, AnnotatedElement annotatedElement) {
        this.setLoadedFromAnnotation();
        this.setLocation(annotatedElement);
        this.setName((String)this.invokeMethod("name", converter));
        this.setConverter((String)this.invokeMethod("converter", converter));
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof StructConverterMetadata) {
            StructConverterMetadata structConverter = (StructConverterMetadata)objectToCompare;
            if (!MetadataHelper.valuesMatch(this.getName(), structConverter.getName())) {
                return false;
            }
            return MetadataHelper.valuesMatch(this.m_converter, structConverter.getConverter());
        }
        return false;
    }

    public String getConverter() {
        return this.m_converter;
    }

    public String getConverterClassName() {
        if (this.getConverter().equals("JGEOMETRY")) {
            return "org.eclipse.persistence.platform.database.oracle.converters.JGeometryConverter";
        }
        return this.getConverter();
    }

    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        if (mapping.isAbstractDirectMapping()) {
            AbstractDirectMapping directMapping = (AbstractDirectMapping)mapping;
            directMapping.setFieldType(2002);
            directMapping.setConverter(null);
            directMapping.setConverterClassName(null);
        } else if (!mapping.isDirectCollectionMapping() && !mapping.isDirectMapMapping()) {
            throw ValidationException.invalidMappingForStructConverter(this.getName(), mapping);
        }
    }

    public void setConverter(String converter) {
        this.m_converter = converter;
    }
}

