/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.inheritance;

import java.lang.annotation.Annotation;
import javax.persistence.InheritanceType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.inheritance.MetadataHelper;

public class InheritanceMetadata {
    private Enum m_strategy;

    public InheritanceMetadata() {
    }

    public InheritanceMetadata(Annotation inheritance) {
        if (inheritance != null) {
            this.setStrategy((Enum)MetadataHelper.invokeMethod("strategy", inheritance));
        }
    }

    public Enum getStrategy() {
        return this.m_strategy;
    }

    public void process(MetadataDescriptor descriptor, Class javaClass) {
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.m_strategy == null || this.m_strategy.equals(InheritanceType.SINGLE_TABLE)) {
            classDescriptor.getInheritancePolicy().setSingleTableStrategy();
        } else if (this.m_strategy.equals(InheritanceType.JOINED)) {
            classDescriptor.getInheritancePolicy().setJoinedStrategy();
        } else if (this.m_strategy.equals(InheritanceType.TABLE_PER_CLASS)) {
            throw ValidationException.tablePerClassInheritanceNotSupported(javaClass);
        }
    }

    public void setStrategy(Enum strategy) {
        this.m_strategy = strategy;
    }
}

