/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResultMetadata {
    private Class m_entityClass;
    private List<FieldResultMetadata> m_fieldResults;
    private String m_discriminatorColumn;
    private String m_entityClassName;

    public EntityResultMetadata() {
    }

    public EntityResultMetadata(Annotation entityResult) {
        this.m_entityClass = (Class)MetadataHelper.invokeMethod("entityClass", entityResult);
        this.m_discriminatorColumn = (String)MetadataHelper.invokeMethod("discriminatorColumn", entityResult);
        this.setFieldResults((Annotation[])MetadataHelper.invokeMethod("fields", entityResult));
    }

    public String getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    public String getEntityClassName() {
        return this.m_entityClassName;
    }

    public List<FieldResultMetadata> getFieldResults() {
        return this.m_fieldResults;
    }

    public boolean hasFieldResults() {
        return this.m_fieldResults != null && !this.m_fieldResults.isEmpty();
    }

    public void setDiscriminatorColumn(String discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setEntityClass(Class entityClass) {
        this.m_entityClass = entityClass;
    }

    public void setEntityClassName(String entityClassName) {
        this.m_entityClassName = entityClassName;
    }

    protected void setFieldResults(Annotation[] fieldResults) {
        this.m_fieldResults = new ArrayList<FieldResultMetadata>();
        for (Annotation fieldResult : fieldResults) {
            this.m_fieldResults.add(new FieldResultMetadata(fieldResult));
        }
    }

    public void setFieldResults(List<FieldResultMetadata> fieldResults) {
        this.m_fieldResults = fieldResults;
    }
}

