/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;

public class ReadTransformerMetadata {
    private Class m_transformerClass;
    private String m_transformerClassName;
    private String m_method;

    protected void applyClass(TransformationMapping mapping) {
        if (!AttributeTransformer.class.isAssignableFrom(this.getTransformerClass())) {
            throw ValidationException.readTransformerClassDoesntImplementAttributeTransformer(mapping.getAttributeName(), mapping.getDescriptor().getJavaClassName());
        }
        mapping.setAttributeTransformerClassName(this.getTransformerClass().getName());
    }

    protected void applyMethod(TransformationMapping mapping) {
        mapping.setAttributeTransformation(this.getMethod());
    }

    public String getMethod() {
        return this.m_method;
    }

    public Class getTransformerClass() {
        return this.m_transformerClass;
    }

    public String getTransformerClassName() {
        return this.m_transformerClassName;
    }

    public boolean hasClass() {
        return this.m_transformerClass != null && !this.m_transformerClass.equals(Void.TYPE);
    }

    public boolean hasClassName() {
        return this.m_transformerClassName != null && this.m_transformerClassName.length() > 0;
    }

    public boolean hasMethod() {
        return this.m_method != null && this.m_method.length() > 0;
    }

    public void process(TransformationMapping mapping) {
        if (this.hasMethod()) {
            if (this.hasClass()) {
                this.throwBothClassAndMethodSpecifiedException(mapping);
            } else {
                this.applyMethod(mapping);
            }
        } else if (this.hasClass()) {
            this.applyClass(mapping);
        } else {
            this.throwNeitherClassNorMethodSpecifiedException(mapping);
        }
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public void setTransformerClass(Class transformerClass) {
        this.m_transformerClass = transformerClass;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.m_transformerClassName = transformerClassName;
    }

    protected void throwBothClassAndMethodSpecifiedException(TransformationMapping mapping) {
        throw ValidationException.readTransformerHasBothClassAndMethod(mapping.getAttributeName(), mapping.getDescriptor().getJavaClassName());
    }

    protected void throwNeitherClassNorMethodSpecifiedException(TransformationMapping mapping) {
        throw ValidationException.readTransformerHasNeitherClassNorMethod(mapping.getAttributeName(), mapping.getDescriptor().getJavaClassName());
    }
}

