/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.EntityResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsWriter;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEntityMappings {
    private ClassLoader m_loader;
    private List<EntityAccessor> m_entities;
    private List<ConverterMetadata> m_converters;
    private List<EmbeddableAccessor> m_embeddables;
    private List<MappedSuperclassAccessor> m_mappedSuperclasses;
    private List<NamedNativeQueryMetadata> m_namedNativeQueries;
    private List<NamedQueryMetadata> m_namedQueries;
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters;
    private List<SequenceGeneratorMetadata> m_sequenceGenerators;
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private List<StructConverterMetadata> m_structConverters;
    private List<TableGeneratorMetadata> m_tableGenerators;
    private List<TypeConverterMetadata> m_typeConverters;
    private MetadataProject m_project;
    private String m_access;
    private String m_catalog;
    private String m_description;
    private String m_package;
    private String m_schema;
    private String m_version;
    private URL m_mappingFileURL;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;

    public String getAccess() {
        return this.m_access;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    static Class getClassForName(String classname, ClassLoader loader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, loader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    public Class getClassForName(String className) {
        if (className == null || className.equals("")) {
            return Void.TYPE;
        }
        if (className.equalsIgnoreCase("Boolean")) {
            return Boolean.class;
        }
        if (className.equalsIgnoreCase("Byte")) {
            return Byte.class;
        }
        if (className.equalsIgnoreCase("Character")) {
            return Character.class;
        }
        if (className.equalsIgnoreCase("Double")) {
            return Double.class;
        }
        if (className.equalsIgnoreCase("Float")) {
            return Float.class;
        }
        if (className.equalsIgnoreCase("Integer")) {
            return Integer.class;
        }
        if (className.equalsIgnoreCase("Long")) {
            return Long.class;
        }
        if (className.equalsIgnoreCase("Number")) {
            return Number.class;
        }
        if (className.equalsIgnoreCase("Short")) {
            return Short.class;
        }
        if (className.equalsIgnoreCase("String")) {
            return String.class;
        }
        return XMLEntityMappings.getClassForName(this.getFullyQualifiedClassName(className), this.m_loader);
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected String getDefaultCatalog() {
        if (this.m_catalog == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getCatalog();
        }
        return this.m_catalog;
    }

    protected String getDefaultSchema() {
        if (this.m_schema == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getSchema();
        }
        return this.m_schema;
    }

    public List<EmbeddableAccessor> getEmbeddables() {
        return this.m_embeddables;
    }

    public List<EntityAccessor> getEntities() {
        return this.m_entities;
    }

    public String getFullyQualifiedClassName(String className) {
        if (this.m_package.equals("")) {
            return className;
        }
        if (className.indexOf(".") > -1) {
            return className;
        }
        if (this.m_package.endsWith(".")) {
            return this.m_package + className;
        }
        return this.m_package + "." + className;
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public URL getMappingFile() {
        return this.m_mappingFileURL;
    }

    public String getMappingFileName() {
        return this.m_mappingFileURL.toString();
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public String getPackage() {
        return this.m_package;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public List<SequenceGeneratorMetadata> getSequenceGenerators() {
        return this.m_sequenceGenerators;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TableGeneratorMetadata> getTableGenerators() {
        return this.m_tableGenerators;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void initPersistenceUnitClasses() {
        for (EntityAccessor entity : this.getEntities()) {
            Class entityClass = this.getClassForName(entity.getClassName());
            entity.init(new MetadataClass(entityClass), new MetadataDescriptor(entityClass, entity), this.m_project, this);
            this.m_project.addEntityAccessor(entity);
            this.processEntityMappingsDefaults(entity);
        }
        for (EmbeddableAccessor embeddable : this.getEmbeddables()) {
            Class embeddableClass = this.getClassForName(embeddable.getClassName());
            embeddable.init(new MetadataClass(embeddableClass), new MetadataDescriptor(embeddableClass, embeddable), this.m_project, this);
            this.m_project.addEmbeddableAccessor(embeddable);
            this.processEntityMappingsDefaults(embeddable);
        }
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            mappedSuperclass.setMappingFile(this.getMappingFileName());
            mappedSuperclass.setEntityMappings(this);
            String mappedSuperclassClassName = this.getClassForName(mappedSuperclass.getClassName()).getName();
            this.m_project.addMappedSuperclass(mappedSuperclassClassName, mappedSuperclass);
        }
    }

    public void process() {
        this.processConverters(this.m_converters);
        this.processTypeConverters(this.m_typeConverters);
        this.processObjectTypeConverters(this.m_objectTypeConverters);
        this.processStructConverters(this.m_structConverters);
        for (TableGeneratorMetadata tableGenerator : this.m_tableGenerators) {
            this.processTableGenerator(tableGenerator, this.getDefaultCatalog(), this.getDefaultSchema(), this.getMappingFileName());
        }
        for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators) {
            this.processSequenceGenerator(sequenceGenerator, this.getMappingFileName());
        }
        this.processNamedQueries(this.m_namedQueries, this.getMappingFileName());
        this.processNamedNativeQueries(this.m_namedNativeQueries, this.getMappingFileName());
        this.processNamedStoredProcedureQueries(this.m_namedStoredProcedureQueries, this.getMappingFileName());
        this.processSqlResultSetMappings(this.m_sqlResultSetMappings);
        for (EntityAccessor entity : this.m_entities) {
            if (entity.isProcessed()) continue;
            entity.process();
            entity.setIsProcessed();
        }
    }

    public void processConverters(List<ConverterMetadata> converters) {
        for (ConverterMetadata converter : converters) {
            converter.setLocation(this.getMappingFileName());
            converter.setClassName(this.getFullyQualifiedClassName(converter.getClassName()));
            this.m_project.addConverter(converter);
        }
    }

    protected void processEntityMappingsDefaults(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (accessor.getAccess() != null) {
            descriptor.setXMLAccess(accessor.getAccess());
        } else if (this.m_access != null) {
            descriptor.setXMLAccess(this.m_access);
        }
        if (this.m_catalog != null) {
            descriptor.setXMLCatalog(this.m_catalog);
        }
        if (this.m_schema != null) {
            descriptor.setXMLSchema(this.m_schema);
        }
        if (accessor.isMetadataComplete()) {
            descriptor.setIgnoreAnnotations(true);
        }
        accessor.setMappingFile(this.getMappingFileName());
        accessor.setEntityMappings(this);
    }

    public void processNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries, String location) {
        for (NamedNativeQueryMetadata namedNativeQuery : namedNativeQueries) {
            namedNativeQuery.setLocation(location);
            namedNativeQuery.setResultClass(this.getClassForName(namedNativeQuery.getResultClassName()));
            this.m_project.addNamedNativeQuery(namedNativeQuery);
        }
    }

    public void processNamedQueries(List<NamedQueryMetadata> namedQueries, String location) {
        for (NamedQueryMetadata namedQuery : namedQueries) {
            namedQuery.setLocation(location);
            this.m_project.addNamedQuery(namedQuery);
        }
    }

    public void processNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries, String location) {
        for (NamedStoredProcedureQueryMetadata namedStoredProcedureQuery : namedStoredProcedureQueries) {
            namedStoredProcedureQuery.setLocation(location);
            namedStoredProcedureQuery.setResultClass(this.getClassForName(namedStoredProcedureQuery.getResultClassName()));
            for (StoredProcedureParameterMetadata procedureParameter : namedStoredProcedureQuery.getProcedureParameters()) {
                procedureParameter.setType(this.getClassForName(procedureParameter.getTypeName()));
            }
            this.m_project.addNamedStoredProcedureQuery(namedStoredProcedureQuery);
        }
    }

    public void processObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        for (ObjectTypeConverterMetadata objectTypeConverter : objectTypeConverters) {
            objectTypeConverter.setLocation(this.getMappingFileName());
            objectTypeConverter.setDataType(this.getClassForName(objectTypeConverter.getDataTypeName()));
            objectTypeConverter.setObjectType(this.getClassForName(objectTypeConverter.getObjectTypeName()));
            this.m_project.addConverter(objectTypeConverter);
        }
    }

    public void processPersistenceUnitMetadata() {
        if (this.m_persistenceUnitMetadata != null) {
            this.m_project.setPersistenceUnitMetadata(this.m_persistenceUnitMetadata);
            for (EntityListenerMetadata defaultListener : this.m_persistenceUnitMetadata.getDefaultListeners()) {
                this.m_project.addDefaultListener(defaultListener);
            }
        }
    }

    public void processSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator, String location) {
        sequenceGenerator.setLocation(location);
        this.m_project.addSequenceGenerator(sequenceGenerator);
    }

    public void processSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        for (SQLResultSetMappingMetadata sqlResultSetMapping : sqlResultSetMappings) {
            for (EntityResultMetadata entityResult : sqlResultSetMapping.getEntityResults()) {
                entityResult.setEntityClass(this.getClassForName(entityResult.getEntityClassName()));
            }
            sqlResultSetMapping.process(this.m_project);
        }
    }

    public void processStructConverters(List<StructConverterMetadata> structConverters) {
        for (StructConverterMetadata structConverter : structConverters) {
            structConverter.setLocation(this.getMappingFileName());
            this.m_project.addStructConverter(structConverter);
        }
    }

    public void processTableGenerator(TableGeneratorMetadata tableGenerator, String defaultCatalog, String defaultSchema, String location) {
        tableGenerator.setLocation(location);
        this.m_project.addTableGenerator(tableGenerator, defaultCatalog, defaultSchema);
    }

    public void processTypeConverters(List<TypeConverterMetadata> typeConverters) {
        for (TypeConverterMetadata typeConverter : typeConverters) {
            typeConverter.setLocation(this.getMappingFileName());
            typeConverter.setDataType(this.getClassForName(typeConverter.getDataTypeName()));
            typeConverter.setObjectType(this.getClassForName(typeConverter.getObjectTypeName()));
            this.m_project.addConverter(typeConverter);
        }
    }

    public MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor accessor, MetadataDescriptor descriptor) {
        try {
            XMLEntityMappings entityMappingsOut = new XMLEntityMappings();
            entityMappingsOut.setVersion(this.getVersion());
            ArrayList<MappedSuperclassAccessor> list = new ArrayList<MappedSuperclassAccessor>();
            list.add(accessor);
            entityMappingsOut.setMappedSuperclasses(list);
            File file = new File("tempToDelete.xml");
            XMLEntityMappingsWriter.write(entityMappingsOut, file.toURI());
            XMLEntityMappings entityMappings = XMLEntityMappingsReader.read(file.toURL(), this.m_loader);
            file.delete();
            MappedSuperclassAccessor mappedSuperclass = entityMappings.getMappedSuperclasses().get(0);
            Class mappedSuperclassClass = this.getClassForName(mappedSuperclass.getClassName());
            mappedSuperclass.setMappingFile(this.getMappingFileName());
            mappedSuperclass.setEntityMappings(this);
            mappedSuperclass.init(new MetadataClass(mappedSuperclassClass), descriptor, this.m_project, this);
            return mappedSuperclass;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setEmbeddables(List<EmbeddableAccessor> embeddables) {
        this.m_embeddables = embeddables;
    }

    public void setEntities(List<EntityAccessor> entities) {
        this.m_entities = entities;
    }

    public void setLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public void setMappedSuperclasses(List<MappedSuperclassAccessor> mappedSuperclasses) {
        this.m_mappedSuperclasses = mappedSuperclasses;
    }

    public void setMappingFile(URL mappingFileURL) {
        this.m_mappingFileURL = mappingFileURL;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        this.m_namedNativeQueries = namedNativeQueries;
    }

    public void setNamedQueries(List<NamedQueryMetadata> namedQueries) {
        this.m_namedQueries = namedQueries;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries) {
        this.m_namedStoredProcedureQueries = namedStoredProcedureQueries;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setPackage(String pkg) {
        this.m_package = pkg;
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        this.m_persistenceUnitMetadata = persistenceUnitMetadata;
    }

    public void setProject(MetadataProject project) {
        this.m_project = project;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setSequenceGenerators(List<SequenceGeneratorMetadata> sequenceGenerators) {
        this.m_sequenceGenerators = sequenceGenerators;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        this.m_sqlResultSetMappings = sqlResultSetMappings;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTableGenerators(List<TableGeneratorMetadata> tableGenerators) {
        this.m_tableGenerators = tableGenerators;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }
}

