/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.transaction;

import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.jpa.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.jpa.transaction.EntityTransactionWrapper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class EntityTransactionImpl
implements EntityTransaction {
    protected EntityTransactionWrapper wrapper;
    protected boolean active = false;
    protected boolean rollbackOnly = false;

    public EntityTransactionImpl(EntityTransactionWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionIsActive().getMessage());
        }
        if (this.wrapper.getEntityManager().isExtended()) {
            this.wrapper.localUOW = this.wrapper.getEntityManager().getActivePersistenceContext(null);
            this.wrapper.localUOW.setShouldTerminateTransaction(false);
        } else {
            this.wrapper.localUOW = new RepeatableWriteUnitOfWork(this.wrapper.getEntityManager().getServerSession().acquireClientSession());
            this.wrapper.localUOW.setShouldTerminateTransaction(false);
            this.wrapper.localUOW.setShouldCascadeCloneToJoinedRelationship(true);
        }
        this.active = true;
    }

    public void commit() {
        try {
            this.commitInternal();
        }
        catch (EclipseLinkException tlException) {
            throw new RollbackException((Throwable)tlException);
        }
    }

    protected void commitInternal() {
        block11: {
            if (!this.isActive()) {
                throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
            }
            try {
                if (this.wrapper.localUOW == null) break block11;
                this.wrapper.localUOW.setShouldTerminateTransaction(true);
                if (!this.rollbackOnly) {
                    if (this.wrapper.localUOW.shouldResumeUnitOfWorkOnTransactionCompletion()) {
                        this.wrapper.localUOW.commitAndResume();
                        return;
                    }
                    this.wrapper.localUOW.commit();
                    this.wrapper.localUOW.clearForClose(false);
                    break block11;
                }
                throw new RollbackException(ExceptionLocalization.buildMessage("rollback_because_of_rollback_only"));
            }
            catch (RuntimeException ex) {
                if (this.wrapper.localUOW != null) {
                    this.wrapper.getEntityManager().removeExtendedPersistenceContext();
                    this.wrapper.localUOW.release();
                    this.wrapper.localUOW.getParent().release();
                }
                if (!this.rollbackOnly) {
                    throw new RollbackException((Throwable)ex);
                }
                throw ex;
            }
            finally {
                this.active = false;
                this.rollbackOnly = false;
                this.wrapper.setLocalUnitOfWork(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        try {
            if (this.wrapper.getLocalUnitOfWork() != null) {
                this.wrapper.localUOW.setShouldTerminateTransaction(true);
                this.wrapper.localUOW.release();
                this.wrapper.localUOW.getParent().release();
            }
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.getEntityManager().removeExtendedPersistenceContext();
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        this.rollbackOnly = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isActive()) {
                this.rollback();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        return this.rollbackOnly;
    }

    public boolean isActive() {
        return this.active;
    }
}

