/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.antlr.runtime.BitSet;
import org.eclipse.persistence.internal.libraries.antlr.runtime.EarlyExitException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.FailedPredicateException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.IntStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedNotSetException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedSetException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedTokenException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.MismatchedTreeNodeException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.NoViableAltException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;

public abstract class BaseRecognizer {
    public static final int MEMO_RULE_FAILED = -2;
    public static final int MEMO_RULE_UNKNOWN = -1;
    public static final int INITIAL_FOLLOW_STACK_SIZE = 100;
    public static final Integer MEMO_RULE_FAILED_I = new Integer(-2);
    public static final int DEFAULT_TOKEN_CHANNEL = 0;
    public static final int HIDDEN = 99;
    public static final String NEXT_TOKEN_RULE_NAME = "nextToken";
    protected BitSet[] following = new BitSet[100];
    protected int _fsp = -1;
    protected boolean errorRecovery = false;
    protected int lastErrorIndex = -1;
    protected boolean failed = false;
    protected int backtracking = 0;
    protected Map[] ruleMemo;

    public void reset() {
        this._fsp = -1;
        this.errorRecovery = false;
        this.lastErrorIndex = -1;
        this.failed = false;
        this.backtracking = 0;
        for (int i = 0; this.ruleMemo != null && i < this.ruleMemo.length; ++i) {
            this.ruleMemo[i] = null;
        }
    }

    public void match(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        if (input.LA(1) == ttype) {
            input.consume();
            this.errorRecovery = false;
            this.failed = false;
            return;
        }
        if (this.backtracking > 0) {
            this.failed = true;
            return;
        }
        this.mismatch(input, ttype, follow);
    }

    public void matchAny(IntStream input) {
        this.errorRecovery = false;
        this.failed = false;
        input.consume();
    }

    protected void mismatch(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        MismatchedTokenException mte = new MismatchedTokenException(ttype, input);
        this.recoverFromMismatchedToken(input, mte, ttype, follow);
    }

    public void reportError(RecognitionException e) {
        if (this.errorRecovery) {
            return;
        }
        this.errorRecovery = true;
        this.displayRecognitionError(this.getTokenNames(), e);
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        String hdr = this.getErrorHeader(e);
        String msg = this.getErrorMessage(e, tokenNames);
        this.emitErrorMessage(hdr + " " + msg);
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        String msg = null;
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            String tokenName = "<unknown>";
            tokenName = mte.expecting == -1 ? "EOF" : tokenNames[mte.expecting];
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting " + tokenName;
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            String tokenName = "<unknown>";
            tokenName = mtne.expecting == -1 ? "EOF" : tokenNames[mtne.expecting];
            msg = "mismatched tree node: " + mtne.node + " expecting " + tokenName;
        } else if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            msg = "no viable alternative at input " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof EarlyExitException) {
            EarlyExitException eee = (EarlyExitException)e;
            msg = "required (...)+ loop did not match anything at input " + this.getTokenErrorDisplay(e.token);
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting set " + mse.expecting;
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            msg = "mismatched input " + this.getTokenErrorDisplay(e.token) + " expecting set " + mse.expecting;
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            msg = "rule " + fpe.ruleName + " failed predicate: {" + fpe.predicateText + "}?";
        }
        return msg;
    }

    public String getErrorHeader(RecognitionException e) {
        return "line " + e.line + ":" + e.charPositionInLine;
    }

    public String getTokenErrorDisplay(Token t) {
        String s = t.getText();
        if (s == null) {
            s = t.getType() == -1 ? "<EOF>" : "<" + t.getType() + ">";
        }
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\t", "\\\\t");
        return "'" + s + "'";
    }

    public void emitErrorMessage(String msg) {
        System.err.println(msg);
    }

    public void recover(IntStream input, RecognitionException re) {
        if (this.lastErrorIndex == input.index()) {
            input.consume();
        }
        this.lastErrorIndex = input.index();
        BitSet followSet = this.computeErrorRecoverySet();
        this.beginResync();
        this.consumeUntil(input, followSet);
        this.endResync();
    }

    public void beginResync() {
    }

    public void endResync() {
    }

    protected BitSet computeErrorRecoverySet() {
        return this.combineFollows(false);
    }

    protected BitSet computeContextSensitiveRuleFOLLOW() {
        return this.combineFollows(true);
    }

    protected BitSet combineFollows(boolean exact) {
        int top = this._fsp;
        BitSet followSet = new BitSet();
        for (int i = top; i >= 0; --i) {
            BitSet localFollowSet = this.following[i];
            followSet.orInPlace(localFollowSet);
            if (exact && !localFollowSet.member(1)) break;
        }
        followSet.remove(1);
        return followSet;
    }

    public void recoverFromMismatchedToken(IntStream input, RecognitionException e, int ttype, BitSet follow) throws RecognitionException {
        if (input.LA(2) == ttype) {
            this.reportError(e);
            this.beginResync();
            input.consume();
            this.endResync();
            input.consume();
            return;
        }
        if (!this.recoverFromMismatchedElement(input, e, follow)) {
            throw e;
        }
    }

    public void recoverFromMismatchedSet(IntStream input, RecognitionException e, BitSet follow) throws RecognitionException {
        if (!this.recoverFromMismatchedElement(input, e, follow)) {
            throw e;
        }
    }

    protected boolean recoverFromMismatchedElement(IntStream input, RecognitionException e, BitSet follow) {
        if (follow == null) {
            return false;
        }
        if (follow.member(1)) {
            BitSet viableTokensFollowingThisRule = this.computeContextSensitiveRuleFOLLOW();
            follow = follow.or(viableTokensFollowingThisRule);
            follow.remove(1);
        }
        if (follow.member(input.LA(1))) {
            this.reportError(e);
            return true;
        }
        return false;
    }

    public void consumeUntil(IntStream input, int tokenType) {
        int ttype = input.LA(1);
        while (ttype != -1 && ttype != tokenType) {
            input.consume();
            ttype = input.LA(1);
        }
    }

    public void consumeUntil(IntStream input, BitSet set) {
        int ttype = input.LA(1);
        while (ttype != -1 && !set.member(ttype)) {
            input.consume();
            ttype = input.LA(1);
        }
    }

    protected void pushFollow(BitSet fset) {
        if (this._fsp + 1 >= this.following.length) {
            BitSet[] f = new BitSet[this.following.length * 2];
            System.arraycopy(this.following, 0, f, 0, this.following.length - 1);
            this.following = f;
        }
        this.following[++this._fsp] = fset;
    }

    public List getRuleInvocationStack() {
        String parserClassName = this.getClass().getName();
        return BaseRecognizer.getRuleInvocationStack(new Throwable(), parserClassName);
    }

    public static List getRuleInvocationStack(Throwable e, String recognizerClassName) {
        ArrayList<String> rules = new ArrayList<String>();
        StackTraceElement[] stack = e.getStackTrace();
        int i = 0;
        for (i = stack.length - 1; i >= 0; --i) {
            StackTraceElement t = stack[i];
            if (t.getClassName().startsWith("org.eclipse.persistence.internal.libraries.antlr.runtime.") || t.getMethodName().equals(NEXT_TOKEN_RULE_NAME) || !t.getClassName().equals(recognizerClassName)) continue;
            rules.add(t.getMethodName());
        }
        return rules;
    }

    public int getBacktrackingLevel() {
        return this.backtracking;
    }

    public String[] getTokenNames() {
        return null;
    }

    public String getGrammarFileName() {
        return null;
    }

    public List toStrings(List tokens) {
        if (tokens == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            strings.add(((Token)tokens.get(i)).getText());
        }
        return strings;
    }

    public int getRuleMemoization(int ruleIndex, int ruleStartIndex) {
        Integer stopIndexI;
        if (this.ruleMemo[ruleIndex] == null) {
            this.ruleMemo[ruleIndex] = new HashMap();
        }
        if ((stopIndexI = (Integer)this.ruleMemo[ruleIndex].get(new Integer(ruleStartIndex))) == null) {
            return -1;
        }
        return stopIndexI;
    }

    public boolean alreadyParsedRule(IntStream input, int ruleIndex) {
        int stopIndex = this.getRuleMemoization(ruleIndex, input.index());
        if (stopIndex == -1) {
            return false;
        }
        if (stopIndex == -2) {
            this.failed = true;
        } else {
            input.seek(stopIndex + 1);
        }
        return true;
    }

    public void memoize(IntStream input, int ruleIndex, int ruleStartIndex) {
        int stopTokenIndex;
        int n = stopTokenIndex = this.failed ? -2 : input.index() - 1;
        if (this.ruleMemo[ruleIndex] != null) {
            this.ruleMemo[ruleIndex].put(new Integer(ruleStartIndex), new Integer(stopTokenIndex));
        }
    }

    public int getRuleMemoizationCacheSize() {
        int n = 0;
        for (int i = 0; this.ruleMemo != null && i < this.ruleMemo.length; ++i) {
            Map ruleMap = this.ruleMemo[i];
            if (ruleMap == null) continue;
            n += ruleMap.size();
        }
        return n;
    }

    public void traceIn(String ruleName, int ruleIndex, Object inputSymbol) {
        System.out.print("enter " + ruleName + " " + inputSymbol);
        if (this.failed) {
            System.out.println(" failed=" + this.failed);
        }
        if (this.backtracking > 0) {
            System.out.print(" backtracking=" + this.backtracking);
        }
        System.out.println();
    }

    public void traceOut(String ruleName, int ruleIndex, Object inputSymbol) {
        System.out.print("exit " + ruleName + " " + inputSymbol);
        if (this.failed) {
            System.out.println(" failed=" + this.failed);
        }
        if (this.backtracking > 0) {
            System.out.print(" backtracking=" + this.backtracking);
        }
        System.out.println();
    }
}

