/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.debug;

import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.debug.DebugEventListener;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;

public class DebugTreeAdaptor
implements TreeAdaptor {
    protected DebugEventListener dbg;
    protected TreeAdaptor adaptor;

    public DebugTreeAdaptor(DebugEventListener dbg, TreeAdaptor adaptor) {
        this.dbg = dbg;
        this.adaptor = adaptor;
    }

    public Object create(Token payload) {
        Object n = this.adaptor.create(payload);
        this.dbg.createNode(this.adaptor.getUniqueID(n), payload.getTokenIndex());
        return n;
    }

    public Object dupTree(Object tree) {
        return this.adaptor.dupTree(tree);
    }

    public Object dupNode(Object treeNode) {
        return this.adaptor.dupNode(treeNode);
    }

    public Object nil() {
        Object n = this.adaptor.nil();
        this.dbg.nilNode(this.adaptor.getUniqueID(n));
        return n;
    }

    public boolean isNil(Object tree) {
        return this.adaptor.isNil(tree);
    }

    public void addChild(Object t, Object child) {
        this.adaptor.addChild(t, child);
        this.dbg.addChild(this.adaptor.getUniqueID(t), this.adaptor.getUniqueID(child));
    }

    public Object becomeRoot(Object newRoot, Object oldRoot) {
        Object n = this.adaptor.becomeRoot(newRoot, oldRoot);
        this.dbg.becomeRoot(this.adaptor.getUniqueID(n), this.adaptor.getUniqueID(oldRoot));
        return n;
    }

    public Object rulePostProcessing(Object root) {
        return this.adaptor.rulePostProcessing(root);
    }

    public void addChild(Object t, Token child) {
        Object n = this.create(child);
        this.addChild(t, n);
    }

    public Object becomeRoot(Token newRoot, Object oldRoot) {
        Object n = this.create(newRoot);
        this.adaptor.becomeRoot(n, oldRoot);
        this.dbg.becomeRoot(this.adaptor.getUniqueID(n), this.adaptor.getUniqueID(oldRoot));
        return n;
    }

    public Object create(int tokenType, Token fromToken) {
        Object n = this.adaptor.create(tokenType, fromToken);
        this.dbg.createNode(this.adaptor.getUniqueID(n), fromToken.getText(), tokenType);
        return n;
    }

    public Object create(int tokenType, Token fromToken, String text) {
        Object n = this.adaptor.create(tokenType, fromToken, text);
        this.dbg.createNode(this.adaptor.getUniqueID(n), text, tokenType);
        return n;
    }

    public Object create(int tokenType, String text) {
        Object n = this.adaptor.create(tokenType, text);
        this.dbg.createNode(this.adaptor.getUniqueID(n), text, tokenType);
        return n;
    }

    public int getType(Object t) {
        return this.adaptor.getType(t);
    }

    public void setType(Object t, int type) {
        this.adaptor.setType(t, type);
    }

    public String getText(Object t) {
        return this.adaptor.getText(t);
    }

    public void setText(Object t, String text) {
        this.adaptor.setText(t, text);
    }

    public Token getToken(Object t) {
        return this.adaptor.getToken(t);
    }

    public void setTokenBoundaries(Object t, Token startToken, Token stopToken) {
        this.adaptor.setTokenBoundaries(t, startToken, stopToken);
        if (t != null && startToken != null && stopToken != null) {
            this.dbg.setTokenBoundaries(this.adaptor.getUniqueID(t), startToken.getTokenIndex(), stopToken.getTokenIndex());
        }
    }

    public int getTokenStartIndex(Object t) {
        return this.adaptor.getTokenStartIndex(t);
    }

    public int getTokenStopIndex(Object t) {
        return this.adaptor.getTokenStopIndex(t);
    }

    public Object getChild(Object t, int i) {
        return this.adaptor.getChild(t, i);
    }

    public int getChildCount(Object t) {
        return this.adaptor.getChildCount(t);
    }

    public int getUniqueID(Object node) {
        return this.adaptor.getUniqueID(node);
    }

    public DebugEventListener getDebugEventListener() {
        return this.dbg;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }
}

