/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class CommonTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected int[] calls;
    protected int _sp = -1;
    protected Map tokenTypeToStreamIndexesMap;
    public static final Set INDEX_ALL = new HashSet();
    protected Set tokenTypesToReverseIndex = null;

    public CommonTreeNodeStream(Object tree) {
        this(new CommonTreeAdaptor(), tree);
    }

    public CommonTreeNodeStream(TreeAdaptor adaptor, Object tree) {
        this(adaptor, tree, 100);
    }

    public CommonTreeNodeStream(TreeAdaptor adaptor, Object tree, int initialBufferSize) {
        this.root = tree;
        this.adaptor = adaptor;
        this.nodes = new ArrayList(initialBufferSize);
        this.down = adaptor.create(2, "DOWN");
        this.up = adaptor.create(3, "UP");
        this.eof = adaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    protected void fillBuffer(Object t) {
        boolean nil = this.adaptor.isNil(t);
        if (!nil) {
            this.nodes.add(t);
            this.fillReverseIndex(t, this.nodes.size() - 1);
        }
        int n = this.adaptor.getChildCount(t);
        if (!nil && n > 0) {
            this.addNavigationNode(2);
        }
        for (int c = 0; c < n; ++c) {
            Object child = this.adaptor.getChild(t, c);
            this.fillBuffer(child);
        }
        if (!nil && n > 0) {
            this.addNavigationNode(3);
        }
    }

    protected void fillReverseIndex(Object node, int streamIndex) {
        if (this.tokenTypesToReverseIndex == null) {
            return;
        }
        if (this.tokenTypeToStreamIndexesMap == null) {
            this.tokenTypeToStreamIndexesMap = new HashMap();
        }
        int tokenType = this.adaptor.getType(node);
        Integer tokenTypeI = new Integer(tokenType);
        if (this.tokenTypesToReverseIndex != INDEX_ALL && !this.tokenTypesToReverseIndex.contains(tokenTypeI)) {
            return;
        }
        Integer streamIndexI = new Integer(streamIndex);
        ArrayList<Integer> indexes = (ArrayList<Integer>)this.tokenTypeToStreamIndexesMap.get(tokenTypeI);
        if (indexes == null) {
            indexes = new ArrayList<Integer>();
            indexes.add(streamIndexI);
            this.tokenTypeToStreamIndexesMap.put(tokenTypeI, indexes);
        } else if (!indexes.contains(streamIndexI)) {
            indexes.add(streamIndexI);
        }
    }

    public void reverseIndex(int tokenType) {
        if (this.tokenTypesToReverseIndex == null) {
            this.tokenTypesToReverseIndex = new HashSet();
        } else if (this.tokenTypesToReverseIndex == INDEX_ALL) {
            return;
        }
        this.tokenTypesToReverseIndex.add(new Integer(tokenType));
    }

    public void reverseIndex(Set tokenTypes) {
        this.tokenTypesToReverseIndex = tokenTypes;
    }

    public int getNodeIndex(Object node) {
        if (this.tokenTypeToStreamIndexesMap == null) {
            return this.getNodeIndexLinearly(node);
        }
        int tokenType = this.adaptor.getType(node);
        Integer tokenTypeI = new Integer(tokenType);
        ArrayList indexes = (ArrayList)this.tokenTypeToStreamIndexesMap.get(tokenTypeI);
        if (indexes == null) {
            return this.getNodeIndexLinearly(node);
        }
        for (int i = 0; i < indexes.size(); ++i) {
            Integer streamIndexI = (Integer)indexes.get(i);
            Object n = this.get(streamIndexI);
            if (n != node) continue;
            return streamIndexI;
        }
        return -1;
    }

    protected int getNodeIndexLinearly(Object node) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object t = this.nodes.get(i);
            if (t != node) continue;
            return i;
        }
        return -1;
    }

    protected void addNavigationNode(int ttype) {
        Object navNode = null;
        navNode = ttype == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(navNode);
    }

    public Object get(int i) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(i);
    }

    public Object LT(int k) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.LB(-k);
        }
        if (this.p + k - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + k - 1);
    }

    protected Object LB(int k) {
        if (k == 0) {
            return null;
        }
        if (this.p - k < 0) {
            return null;
        }
        return this.nodes.get(this.p - k);
    }

    public Object getTreeSource() {
        return this.root;
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokens) {
        this.tokens = tokens;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean uniqueNavigationNodes) {
        this.uniqueNavigationNodes = uniqueNavigationNodes;
    }

    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    public int LA(int i) {
        return this.adaptor.getType(this.LT(i));
    }

    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public int index() {
        return this.p;
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int index) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = index;
    }

    public void push(int index) {
        if (this.calls == null) {
            this.calls = new int[10];
        } else if (this._sp + 1 >= this.calls.length) {
            int[] newStack = new int[this.calls.length * 2];
            System.arraycopy(this.calls, 0, newStack, 0, this.calls.length);
            this.calls = newStack;
        }
        this.calls[++this._sp] = this.p;
        this.seek(index);
    }

    public int pop() {
        int ret = this.calls[this._sp--];
        this.seek(ret);
        return ret;
    }

    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new StreamIterator();
    }

    public String toString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object t = this.nodes.get(i);
            buf.append(" ");
            buf.append(this.adaptor.getType(t));
        }
        return buf.toString();
    }

    public String toString(Object start, Object stop) {
        String text;
        int i;
        if (start == null || stop == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        System.out.println("stop: " + stop);
        if (start instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)start).getToken() + ", ");
        } else {
            System.out.println(start);
        }
        if (stop instanceof CommonTree) {
            System.out.println(((CommonTree)stop).getToken());
        } else {
            System.out.println(stop);
        }
        if (this.tokens != null) {
            int beginTokenIndex = this.adaptor.getTokenStartIndex(start);
            int endTokenIndex = this.adaptor.getTokenStopIndex(stop);
            if (this.adaptor.getType(stop) == 3) {
                endTokenIndex = this.adaptor.getTokenStopIndex(start);
            } else if (this.adaptor.getType(stop) == -1) {
                endTokenIndex = this.size() - 2;
            }
            return this.tokens.toString(beginTokenIndex, endTokenIndex);
        }
        Object t = null;
        for (i = 0; i < this.nodes.size() && (t = this.nodes.get(i)) != start; ++i) {
        }
        StringBuffer buf = new StringBuffer();
        t = this.nodes.get(i);
        while (t != stop) {
            text = this.adaptor.getText(t);
            if (text == null) {
                text = " " + String.valueOf(this.adaptor.getType(t));
            }
            buf.append(text);
            t = this.nodes.get(++i);
        }
        text = this.adaptor.getText(stop);
        if (text == null) {
            text = " " + String.valueOf(this.adaptor.getType(stop));
        }
        buf.append(text);
        return buf.toString();
    }

    protected class StreamIterator
    implements Iterator {
        int i = 0;

        protected StreamIterator() {
        }

        public boolean hasNext() {
            return this.i < CommonTreeNodeStream.this.nodes.size();
        }

        public Object next() {
            int current;
            if ((current = this.i++) < CommonTreeNodeStream.this.nodes.size()) {
                return CommonTreeNodeStream.this.nodes.get(current);
            }
            return CommonTreeNodeStream.this.eof;
        }

        public void remove() {
            throw new RuntimeException("cannot remove nodes from stream");
        }
    }
}

