/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;

public class SerialVersionUIDAdder
extends ClassAdapter {
    protected boolean computeSVUID;
    protected boolean hasSVUID;
    protected long ownSVUID = 0L;
    protected int access;
    protected String className;
    protected String[] interfaces;
    protected Collection svuidFields = new ArrayList();
    protected boolean hasStaticInitializer;
    protected Collection svuidConstructors = new ArrayList();
    protected Collection svuidMethods = new ArrayList();

    public SerialVersionUIDAdder(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        boolean bl = this.computeSVUID = (access & 0x200) == 0;
        if (this.computeSVUID) {
            this.className = name;
            this.access = access;
            this.interfaces = interfaces;
        }
    }

    public CodeVisitor visitMethod(int access, String methodName, String desc, String[] exceptions, Attribute attrs) {
        if (this.computeSVUID) {
            if (methodName.equals("<clinit>")) {
                this.hasStaticInitializer = true;
            }
            int mods = access & 0xD3F;
            if ((access & 2) == 0) {
                if (methodName.equals("<init>")) {
                    this.svuidConstructors.add(new Item(methodName, mods, desc));
                } else if (!methodName.equals("<clinit>")) {
                    this.svuidMethods.add(new Item(methodName, mods, desc));
                }
            }
        }
        return null;
    }

    public void visitField(int access, String fieldName, String desc, Object value, Attribute attrs) {
        if (this.computeSVUID) {
            if (fieldName.equals("serialVersionUID")) {
                this.computeSVUID = false;
                this.hasSVUID = true;
                this.ownSVUID = (Long)value;
            }
            int mods = access & 0xDF;
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                this.svuidFields.add(new Item(fieldName, mods, desc));
            }
        }
    }

    public boolean hasSVUID() {
        return this.hasSVUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long computeSVUID() {
        try {
            if (this.hasSVUID) {
                return this.ownSVUID;
            }
            ByteArrayOutputStream bos = null;
            FilterOutputStream dos = null;
            long svuid = 0L;
            try {
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                ((DataOutputStream)dos).writeUTF(this.className.replace('/', '.'));
                ((DataOutputStream)dos).writeInt(this.access & 0x611);
                Arrays.sort(this.interfaces);
                for (int i = 0; i < this.interfaces.length; ++i) {
                    ((DataOutputStream)dos).writeUTF(this.interfaces[i].replace('/', '.'));
                }
                this.writeItems(this.svuidFields, (DataOutputStream)dos, false);
                if (this.hasStaticInitializer) {
                    ((DataOutputStream)dos).writeUTF("<clinit>");
                    ((DataOutputStream)dos).writeInt(8);
                    ((DataOutputStream)dos).writeUTF("()V");
                }
                this.writeItems(this.svuidConstructors, (DataOutputStream)dos, true);
                this.writeItems(this.svuidMethods, (DataOutputStream)dos, true);
                ((DataOutputStream)dos).flush();
                MessageDigest md = MessageDigest.getInstance("SHA");
                byte[] hashBytes = md.digest(bos.toByteArray());
                for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                    svuid = svuid << 8 | (long)(hashBytes[i] & 0xFF);
                }
            }
            finally {
                if (dos != null) {
                    dos.close();
                }
            }
            return svuid;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void writeItems(Collection itemCollection, DataOutputStream dos, boolean dotted) throws IOException {
        int size = itemCollection.size();
        Object[] items = itemCollection.toArray(new Item[size]);
        Arrays.sort(items);
        for (int i = 0; i < size; ++i) {
            dos.writeUTF(((Item)items[i]).name);
            dos.writeInt(((Item)items[i]).access);
            dos.writeUTF(dotted ? ((Item)items[i]).desc.replace('/', '.') : ((Item)items[i]).desc);
        }
    }

    static class Item
    implements Comparable {
        String name;
        int access;
        String desc;

        Item(String name, int access, String desc) {
            this.name = name;
            this.access = access;
            this.desc = desc;
        }

        public int compareTo(Object o) {
            Item other = (Item)o;
            int retVal = this.name.compareTo(other.name);
            if (retVal == 0) {
                retVal = this.desc.compareTo(other.desc);
            }
            return retVal;
        }
    }
}

