/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.io.FileInputStream;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TreeClassAdapter;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Analyzer;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Frame;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.SimpleVerifier;
import org.eclipse.persistence.internal.libraries.asm.util.CheckCodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.util.TraceCodeVisitor;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean end;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            CheckClassAdapter.printUsage();
        }
        ClassReader cr = args[0].endsWith(".class") ? new ClassReader(new FileInputStream(args[0])) : new ClassReader(args[0]);
        TreeClassAdapter ca = new TreeClassAdapter(null);
        cr.accept(new CheckClassAdapter(ca), true);
        List methods = ca.classNode.methods;
        for (int i = 0; i < methods.size(); ++i) {
            MethodNode method = (MethodNode)methods.get(i);
            if (method.instructions.size() <= 0) continue;
            Analyzer a = new Analyzer(new SimpleVerifier());
            try {
                a.analyze(ca.classNode, method);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                final Frame[] frames = a.getFrames();
                System.out.println(method.name + method.desc);
                TraceCodeVisitor cv = new TraceCodeVisitor(null){

                    public void visitMaxs(int maxStack, int maxLocals) {
                        for (int i = 0; i < this.text.size(); ++i) {
                            String s;
                            String string = s = frames[i] == null ? "null" : frames[i].toString();
                            while (s.length() < maxStack + maxLocals + 1) {
                                s = s + " ";
                            }
                            System.out.print(Integer.toString(i + 100000).substring(1) + " " + s + " : " + this.text.get(i));
                        }
                        System.out.println();
                    }
                };
                for (int j = 0; j < method.instructions.size(); ++j) {
                    Object insn = method.instructions.get(j);
                    if (insn instanceof AbstractInsnNode) {
                        ((AbstractInsnNode)insn).accept(cv);
                        continue;
                    }
                    cv.visitLabel((Label)insn);
                }
                cv.visitMaxs(method.maxStack, method.maxLocals);
            }
        }
    }

    private static void printUsage() {
        System.err.println("TODO.");
        System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
        System.exit(-1);
    }

    public CheckClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 161329);
        CheckCodeAdapter.checkInternalName(name, "class name");
        if (name.equals("java/lang/Object")) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckCodeAdapter.checkInternalName(superName, "super class name");
        }
        if ((access & 0x200) != 0 && !superName.equals("java/lang/Object")) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                CheckCodeAdapter.checkInternalName(interfaces[i], "interface name at index " + i);
            }
        }
        this.cv.visit(version, access, name, superName, interfaces, sourceFile);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkState();
        CheckCodeAdapter.checkInternalName(name, "class name");
        if (outerName != null) {
            CheckCodeAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckCodeAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access, 30239);
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 151775);
        CheckCodeAdapter.checkIdentifier(name, "field name");
        CheckCodeAdapter.checkDesc(desc, false);
        if (value != null) {
            CheckCodeAdapter.checkConstant(value);
        }
        this.cv.visitField(access, name, desc, value, attrs);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 138751);
        CheckCodeAdapter.checkMethodIdentifier(name, "method name");
        CheckCodeAdapter.checkMethodDesc(desc);
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CheckCodeAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        return new CheckCodeAdapter(this.cv.visitMethod(access, name, desc, exceptions, attrs));
    }

    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) != 0 ? 1 : 0;
        int pri = (access & 2) != 0 ? 1 : 0;
        int n = pro = (access & 4) != 0 ? 1 : 0;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) != 0 ? 1 : 0;
        int n2 = abs = (access & 0x400) != 0 ? 1 : 0;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }
}

