/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util.attrs;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapAttribute;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapFrame;
import org.eclipse.persistence.internal.libraries.asm.attrs.StackMapType;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMStackMapAttribute
extends StackMapAttribute
implements ASMifiable {
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        StackMapAttribute attr = (StackMapAttribute)super.read(cr, off, len, buf, codeOff, labels);
        ASMStackMapAttribute result = new ASMStackMapAttribute();
        result.frames = attr.frames;
        return result;
    }

    public void asmify(StringBuffer buf, String varName, Map labelNames) {
        buf.append("{\n");
        buf.append("StackMapAttribute ").append(varName).append("Attr");
        buf.append(" = new StackMapAttribute();\n");
        if (this.frames.size() > 0) {
            for (int i = 0; i < this.frames.size(); ++i) {
                this.asmify((StackMapFrame)this.frames.get(i), buf, varName + "frame" + i, labelNames);
            }
        }
        buf.append(varName).append(".visitAttribute(").append(varName);
        buf.append("Attr);\n}\n");
    }

    void asmify(StackMapFrame f, StringBuffer buf, String varName, Map labelNames) {
        ASMStackMapAttribute.declareLabel(buf, labelNames, f.label);
        buf.append("{\n");
        buf.append("StackMapFrame ").append(varName).append(" = new StackMapFrame();\n");
        buf.append(varName).append(".label = ").append(labelNames.get(f.label)).append(";\n");
        this.asmifyTypeInfo(buf, varName, labelNames, f.locals, "locals");
        this.asmifyTypeInfo(buf, varName, labelNames, f.stack, "stack");
        buf.append("cvAttr.frames.add(").append(varName).append(");\n");
        buf.append("}\n");
    }

    void asmifyTypeInfo(StringBuffer buf, String varName, Map labelNames, List infos, String field) {
        if (infos.size() > 0) {
            buf.append("{\n");
            for (int i = 0; i < infos.size(); ++i) {
                StackMapType typeInfo = (StackMapType)infos.get(i);
                String localName = varName + "Info" + i;
                int type = typeInfo.getType();
                buf.append("StackMapType ").append(localName).append(" = StackMapType.getTypeInfo( StackMapType.ITEM_").append(StackMapType.ITEM_NAMES[type]).append(");\n");
                switch (type) {
                    case 7: {
                        buf.append(localName).append(".setObject(\"").append(typeInfo.getObject()).append("\");\n");
                        break;
                    }
                    case 8: {
                        ASMStackMapAttribute.declareLabel(buf, labelNames, typeInfo.getLabel());
                        buf.append(localName).append(".setLabel(").append(labelNames.get(typeInfo.getLabel())).append(");\n");
                    }
                }
                buf.append(varName).append(".").append(field).append(".add(").append(localName).append(");\n");
            }
            buf.append("}\n");
        }
    }

    static void declareLabel(StringBuffer buf, Map labelNames, Label l) {
        String name = (String)labelNames.get(l);
        if (name == null) {
            name = "l" + labelNames.size();
            labelNames.put(l, name);
            buf.append("Label ").append(name).append(" = new Label();\n");
        }
    }
}

