/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.factories.PersistenceEntityResolver;
import org.eclipse.persistence.internal.sessions.factories.SessionsFactory;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigToplinkProject;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSessionConfigLoader {
    protected String resourceName;
    protected String resourcePath = "sessions.xml";
    protected String sessionName = "default";
    protected boolean shouldLogin = true;
    protected boolean shouldRefresh = false;
    protected ClassLoader classLoader;
    protected boolean shouldCheckClassLoader = false;
    protected Vector exceptionStore;
    protected PersistenceEntityResolver entityResolver;
    protected static final String DEFAULT_RESOURCE_NAME = "sessions.xml";
    protected static final String DEFAULT_RESOURCE_NAME_IN_META_INF = "META-INF/sessions.xml";
    protected static Project project = new XMLSessionConfigProject_11_1_1();

    protected static Project getProject() {
        return project;
    }

    public XMLSessionConfigLoader() {
        this(DEFAULT_RESOURCE_NAME);
    }

    public XMLSessionConfigLoader(String resourceName) {
        this.resourceName = resourceName;
        this.exceptionStore = new Vector();
        this.entityResolver = new PersistenceEntityResolver();
        this.classLoader = ConversionManager.getDefaultManager().getLoader();
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public Vector getExceptionStore() {
        return this.exceptionStore;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public boolean shouldLogin() {
        return this.shouldLogin;
    }

    public void setShouldLogin(boolean shouldLogin) {
        this.shouldLogin = shouldLogin;
    }

    public boolean shouldRefresh() {
        return this.shouldRefresh;
    }

    public void setShouldRefresh(boolean shouldRefresh) {
        this.shouldRefresh = shouldRefresh;
    }

    public boolean shouldCheckClassLoader() {
        return this.shouldCheckClassLoader;
    }

    public void setShouldCheckClassLoader(boolean shouldCheckClassLoader) {
        this.shouldCheckClassLoader = shouldCheckClassLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean load(SessionManager sessionManager, ClassLoader loader) {
        Document document = this.loadDocument(loader);
        if (this.getExceptionStore().isEmpty()) {
            if (document.getDocumentElement().getTagName().equals("sessions")) {
                return this.buildSessionConfigs(sessionManager, loader, document, XMLSessionConfigLoader.getProject());
            }
        } else {
            if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
                return this.buildSessionConfigs(sessionManager, loader, document, new XMLSessionConfigToplinkProject());
            }
            throw SessionLoaderException.finalException(this.getExceptionStore());
        }
        return false;
    }

    private boolean buildSessionConfigs(SessionManager sessionManager, ClassLoader loader, Document document, Project project) {
        XMLContext context = new XMLContext(project);
        XMLUnmarshaller unmarshaller = context.createUnmarshaller();
        SessionConfigs configs = (SessionConfigs)unmarshaller.unmarshal(document);
        SessionsFactory factory = new SessionsFactory();
        Map sessions = factory.buildSessionConfigs(configs, loader);
        for (Map.Entry entry : sessions.entrySet()) {
            if (sessionManager.getSessions().containsKey(entry.getKey())) continue;
            sessionManager.addSession((String)entry.getKey(), (Session)entry.getValue());
        }
        return true;
    }

    public SessionConfigs loadConfigsForMappingWorkbench(ClassLoader loader) {
        return this.loadConfigsForMappingWorkbench(loader, true);
    }

    public SessionConfigs loadConfigsForMappingWorkbench(ClassLoader loader, boolean validate) {
        Document document = this.loadDocument(loader, validate);
        if (this.getExceptionStore().isEmpty()) {
            if (document.getDocumentElement().getTagName().equals("sessions")) {
                XMLContext context = new XMLContext(XMLSessionConfigLoader.getProject());
                XMLUnmarshaller unmarshaller = context.createUnmarshaller();
                return (SessionConfigs)unmarshaller.unmarshal(document);
            }
            throw SessionLoaderException.InvalidSessionXML();
        }
        if (document.getDocumentElement().getTagName().equals("toplink-sessions")) {
            XMLContext context = new XMLContext(new XMLSessionConfigToplinkProject());
            XMLUnmarshaller unmarshaller = context.createUnmarshaller();
            return (SessionConfigs)unmarshaller.unmarshal(document);
        }
        throw SessionLoaderException.finalException(this.getExceptionStore());
    }

    protected Document loadDocument(ClassLoader loader) {
        return this.loadDocument(loader, SessionManager.shouldUseSchemaValidation());
    }

    protected Document loadDocument(ClassLoader loader, boolean validate) {
        URL inURL = loader.getResource(this.resourceName);
        File inFile = new File(this.resourceName);
        if (inURL == null) {
            if (this.resourceName.equals(DEFAULT_RESOURCE_NAME)) {
                inURL = loader.getResource(DEFAULT_RESOURCE_NAME_IN_META_INF);
            }
            if (inURL == null && !inFile.exists()) {
                throw ValidationException.noSessionsXMLFound(this.resourceName);
            }
        }
        this.resourcePath = inURL == null ? inFile.getAbsolutePath() : inURL.getPath();
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLParser parser = xmlPlatform.newXMLParser();
        if (validate) {
            parser.setValidationMode(3);
        } else {
            parser.setValidationMode(0);
        }
        parser.setWhitespacePreserving(false);
        parser.setXMLSchema(loader.getResource("xsd/eclipse_persistence_sessions_1_0.xsd"));
        parser.setEntityResolver(this.entityResolver);
        parser.setErrorHandler(new XMLSessionConfigLoaderErrorHandler());
        if (inURL == null) {
            return parser.parse(inFile);
        }
        return parser.parse(inURL);
    }

    public class XMLSessionConfigLoaderErrorHandler
    implements ErrorHandler {
        public void warning(SAXParseException e) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(SessionLoaderException.failedToParseXML(ExceptionLocalization.buildMessage("parsing_warning"), e.getLineNumber(), e.getColumnNumber(), e));
        }

        public void error(SAXParseException e) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XMLSessionConfigLoader.this.getExceptionStore().add(e);
        }
    }
}

