/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class InsertObjectQuery
extends WriteObjectQuery {
    public InsertObjectQuery() {
    }

    public InsertObjectQuery(Object objectToInsert) {
        this();
        this.setObject(objectToInsert);
    }

    public InsertObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void executeCommit() throws DatabaseException {
        if (this.getRedirector() != null) {
            this.redirectQuery(this, this.session, this.translationRow);
            return;
        }
        if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException {
        this.executeCommit();
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareInsertObject();
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && queryManager.hasInsertQuery()) {
            return queryManager.getInsertQuery();
        }
        return null;
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        InsertObjectQuery customInsertQuery = (InsertObjectQuery)customQuery;
        customInsertQuery.setObject(this.getObject());
        customInsertQuery.setObjectChangeSet(this.getObjectChangeSet());
        customInsertQuery.setCascadePolicy(this.getCascadePolicy());
        customInsertQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customInsertQuery.setModifyRow(null);
    }

    public boolean isInsertObjectQuery() {
        return true;
    }
}

