/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.PrivateArchivist;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.WebRuntimeDDFile;
import com.sun.enterprise.deployment.node.web.WebBundleNode;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ModuleContentValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class WebArchivist
extends Archivist<WebBundleDescriptor>
implements PrivateArchivist {
    DeploymentDescriptorFile standardDD = new WebDeploymentDescriptorFile();
    private WebBundleDescriptor defaultBundleDescriptor = null;
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_LIB = "WEB-INF/lib";

    @Override
    public ModuleType getModuleType() {
        return ModuleType.WAR;
    }

    @Override
    public void setDescriptor(Application descriptor) {
        Set<WebBundleDescriptor> webBundles = descriptor.getWebBundleDescriptors();
        if (webBundles.size() > 0) {
            this.descriptor = webBundles.iterator().next();
            if (((WebBundleDescriptor)this.descriptor).getModuleDescriptor().isStandalone()) {
                return;
            }
            this.descriptor = null;
        }
    }

    @Override
    public String getWebServicesDeploymentDescriptorPath() {
        return "WEB-INF/webservices.xml";
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        return this.standardDD;
    }

    @Override
    public DeploymentDescriptorFile getConfigurationDDFile() {
        return new WebRuntimeDDFile();
    }

    @Override
    public WebBundleDescriptor getDefaultBundleDescriptor() {
        return this.defaultBundleDescriptor;
    }

    @Override
    public void setDefaultBundleDescriptor(WebBundleDescriptor defaultWbd) {
        this.defaultBundleDescriptor = defaultWbd;
        WebBundleNode.setDefaultBundleDescriptor(this.defaultBundleDescriptor);
    }

    @Override
    protected void postOpen(WebBundleDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        WebBundleDescriptor webBundle = descriptor;
        ModuleContentValidator mdv = new ModuleContentValidator(archive);
        webBundle.visit(mdv);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((WebBundleDescriptor)this.descriptor).setClassLoader(cl);
        ((WebBundleDescriptor)this.descriptor).visit(new ApplicationValidator());
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        return abstractArchive.exists(WEB_INF_CLASSES) || abstractArchive.exists(WEB_INF_LIB);
    }

    @Override
    protected String getArchiveExtension() {
        return ".war";
    }

    @Override
    public Vector getLibraries(Archive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (!entryName.startsWith(WEB_INF_LIB) || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPersistenceDeploymentDescriptors(ReadableArchive archive, WebBundleDescriptor descriptor) throws IOException, SAXParseException {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, "WebArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", archive.getURI());
        }
        HashMap<String, ReadableArchive> subArchives = new HashMap<String, ReadableArchive>();
        Enumeration entries = archive.entries();
        String CLASSES_DIR = "WEB-INF/classes/";
        String LIB_DIR = "WEB-INF/lib/";
        String JAR_EXT = ".jar";
        try {
            ReadableArchive libArchive = archive.getSubArchive("WEB-INF/lib/");
            if (libArchive != null) {
                Enumeration libEntries = libArchive.entries();
                while (libEntries.hasMoreElements()) {
                    String path = (String)libEntries.nextElement();
                    if (!path.endsWith(".jar")) continue;
                    if (path.indexOf(47) == -1) {
                        try {
                            subArchives.put("WEB-INF/lib//" + path, libArchive.getSubArchive(path));
                        }
                        catch (IOException ioe) {
                            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                        }
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, "WebArchivist", "readPersistenceDeploymentDescriptors", "skipping {0} as it exists inside a directory in {1}.", new Object[]{path, "WEB-INF/lib/"});
                }
            }
            String pathOfPersistenceXMLInsideClassesDir = "WEB-INF/classes/META-INF/persistence.xml";
            InputStream is = archive.getEntry("WEB-INF/classes/META-INF/persistence.xml");
            if (is != null) {
                is.close();
                subArchives.put("WEB-INF/classes/", archive.getSubArchive("WEB-INF/classes/"));
            }
            for (Map.Entry pathToArchiveEntry : subArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor((ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (ReadableArchive subArchive : subArchives.values()) {
                subArchive.close();
            }
        }
    }
}

