/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainEquinox;
import com.sun.enterprise.glassfish.bootstrap.ASMainFelix;
import com.sun.enterprise.glassfish.bootstrap.ASMainHK2;
import com.sun.enterprise.glassfish.bootstrap.ASMainKnopflerFish;
import java.util.logging.Logger;

public class ASMain {
    static final Logger logger = Logger.getAnonymousLogger();
    private static String PLATFORM_PROPERTY_KEY = "GlassFish_Platform";

    public static void main(String[] args) {
        Platform platform = Platform.HK2;
        String temp = System.getProperty(PLATFORM_PROPERTY_KEY);
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv(PLATFORM_PROPERTY_KEY);
        }
        if (temp != null && temp.trim().length() != 0) {
            platform = Platform.valueOf(temp.trim());
        }
        System.setProperty(PLATFORM_PROPERTY_KEY, platform.toString());
        switch (platform) {
            case Felix: {
                logger.info("Launching GlassFish on Apache Felix OSGi platform");
                new ASMainFelix(logger, args).run();
                break;
            }
            case Equinox: {
                logger.info("Launching GlassFish on Equinox OSGi platform");
                new ASMainEquinox(logger, args).run();
                break;
            }
            case KnopflerFish: {
                logger.info("Launching GlassFish on Knopflerfish OSGi platform");
                new ASMainKnopflerFish(logger, args).run();
                break;
            }
            case HK2: {
                logger.info("Launching GlassFish on HK2 platform");
                new ASMainHK2(logger).run(args);
                break;
            }
            default: {
                throw new RuntimeException("Platform not yet supported");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Platform {
        HK2,
        Felix,
        KnopflerFish,
        Equinox;

    }
}

