/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainOSGi;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ASMainEquinox
extends ASMainOSGi {
    public ASMainEquinox(Logger logger, String ... args) {
        super(logger, args);
    }

    protected void setFwDir() {
        String fwPath = System.getenv("EQUINOX_HOME");
        if (fwPath == null) {
            fwPath = new File(this.glassfishDir, "equinox").getAbsolutePath();
        }
        this.fwDir = new File(fwPath);
        if (!this.fwDir.exists()) {
            throw new RuntimeException("Can't locate Equinox at " + fwPath);
        }
    }

    protected URL[] getFWJars() {
        final ArrayList urls = new ArrayList();
        this.fwDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.getName().endsWith(".jar")) {
                    try {
                        urls.add(pathname.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }
        });
        return urls.toArray(new URL[0]);
    }

    protected void launchOSGiFW() throws Exception {
        System.setProperty("osgi.configuration.area", new File(this.fwDir, "configuration").getCanonicalPath());
        System.setProperty("osgi.clean", "true");
        Class<?> mc = this.launcherCL.loadClass(this.getFWMainClassName());
        final String[] args = new String[]{};
        final Method m = mc.getMethod("main", args.getClass());
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    m.invoke(null, new Object[]{args});
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "OSGi Framework Launcher");
        launcherThread.start();
        launcherThread.join();
        this.logger.info("Framework successfully started");
    }

    private String getFWMainClassName() {
        return "org.eclipse.core.runtime.adaptor.EclipseStarter";
    }
}

