/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.glassfish.bootstrap.MaskingClassLoader;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMainHK2
extends Main {
    Logger logger;
    ASMainHelper helper;
    File glassfishDir;

    public ASMainHK2(Logger logger) {
        this.logger = logger;
        this.helper = new ASMainHelper(logger);
    }

    public ASMainHK2() {
        this(Logger.getAnonymousLogger());
    }

    protected void setParentClassLoader(StartupContext context, ModulesRegistry mr) throws BootException {
        Repository lib;
        Module parentModule;
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        mr.setParentClassLoader(cl);
        this.glassfishDir = context.getRootDirectory();
        Module shared = mr.makeModuleFor("org.glassfish.external:glassfish-jaxb", null);
        if (shared != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (URI location : shared.getModuleDefinition().getLocations()) {
                try {
                    urls.add(location.toURL());
                }
                catch (MalformedURLException e) {
                    throw new BootException("Cannot set up masking class loader", (Throwable)e);
                }
            }
            cl = new MaskingClassLoader(cl, urls.toArray(new URL[urls.size()]), "javax.xml.bind.", "javax.xml.ws.", "com.sun.xml.");
            mr.setParentClassLoader(cl);
        }
        if ((parentModule = mr.makeModuleFor("org.glassfish:javax.javaee", null)) != null) {
            cl = parentModule.getClassLoader();
        }
        this.helper.parseAsEnv(context.getRootDirectory().getParentFile());
        File domainRoot = this.helper.getDomainRoot(context);
        this.helper.verifyDomainRoot(domainRoot);
        ArrayList<Repository> libs = new ArrayList<Repository>();
        Repository jdkToolsRepo = this.helper.getJDKToolsRepo();
        if (jdkToolsRepo != null) {
            libs.add(jdkToolsRepo);
        }
        if ((lib = mr.getRepository("lib")) != null) {
            libs.add(lib);
            File domainlib = new File(domainRoot, "lib");
            if (domainlib.exists()) {
                DirectoryBasedRepository domainLib = new DirectoryBasedRepository("domnainlib", domainlib);
                try {
                    domainLib.initialize();
                    mr.addRepository((Repository)domainLib);
                    libs.add((Repository)domainLib);
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Error while initializing domain lib repository", e);
                }
            }
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            this.findDerbyClient(urls);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (libs.size() > 0) {
            cl = this.helper.setupSharedCL(cl, urls, libs);
        }
        mr.setParentClassLoader(cl);
    }

    private void findDerbyClient(List<URL> urls) throws MalformedURLException {
        ArrayList<URL> derbyUrls = new ArrayList<URL>();
        File derbyLib = new File(this.glassfishDir.getParent(), "javadb/lib");
        if (!derbyLib.exists() && System.getProperty("java.version").compareTo("1.6") > 0) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        this.helper.addPaths(derbyLib, new String[]{"derbyclient"}, derbyUrls);
        if (derbyUrls.size() > 0) {
            urls.addAll(derbyUrls);
        }
    }

    protected void createRepository(File root, File bootstrapJar, Manifest mf, ModulesRegistry mr) throws BootException {
        super.createRepository(root, bootstrapJar, mf, mr);
        Repository repo = mr.getRepository("shared");
        File repoLocation = new File(repo.getLocation());
        for (File file : repoLocation.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            try {
                DirectoryBasedRepository newRepo = new DirectoryBasedRepository(file.getName(), file);
                newRepo.initialize();
                mr.addRepository((Repository)newRepo);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot initialize repository at " + file.getAbsolutePath(), e);
            }
        }
    }
}

