/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainOSGi;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class ASMainKnopflerFish
extends ASMainOSGi {
    public ASMainKnopflerFish(Logger logger, String ... args) {
        super(logger, args);
    }

    protected void setFwDir() {
        String fwPath = System.getenv("KNOPFLERFISH_HOME");
        if (fwPath == null) {
            fwPath = new File(this.glassfishDir, "knopflerfish.org/osgi/").getAbsolutePath();
        }
        this.fwDir = new File(fwPath);
        if (!this.fwDir.exists()) {
            throw new RuntimeException("Can't locate KnopflerFish at " + fwPath);
        }
    }

    protected URL[] getFWJars() {
        try {
            File file = new File(this.fwDir, "framework.jar");
            return new URL[]{file.toURI().toURL()};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void launchOSGiFW() throws Exception {
        File cacheProfileDir = new File(this.fwDir, "fwdir");
        this.helper.setUpOSGiCache(this.glassfishDir, cacheProfileDir);
        System.setProperty("org.osgi.framework.dir", cacheProfileDir.getCanonicalPath());
        String jars = new File(this.fwDir, "jars/").toURI().toString();
        System.setProperty("org.knopflerfish.gosg.jars", jars);
        String pkgFilePath = new File(this.fwDir, "gfpackages.txt").getAbsolutePath();
        System.setProperty("org.osgi.framework.system.packages.file", pkgFilePath);
        Class<?> mc = this.launcherCL.loadClass(this.getFWMainClassName());
        String xargsURL = new File(this.fwDir, "gf.xargs").toURI().toURL().toString();
        final String[] args = new String[]{"-xargs", xargsURL};
        final Method m = mc.getMethod("main", args.getClass());
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    m.invoke(null, new Object[]{args});
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "OSGi Framework Launcher");
        launcherThread.start();
        launcherThread.join();
        this.logger.info("Framework successfully started");
    }

    private String getFWMainClassName() {
        return "org.knopflerfish.framework.Main";
    }
}

