/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMainHelper;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.DirectoryBasedRepository;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASMainOSGi {
    protected ClassLoader launcherCL;
    protected Logger logger;
    protected ASMainHelper helper;
    protected StartupContext context;
    protected File bootstrapFile;
    protected File glassfishDir;
    protected File domainDir;
    protected File fwDir;
    private String[] additionalJarPrefixes = new String[]{"wstx-asl"};
    private static final String javaeeJarPath = "modules/javax.javaee-10.0-SNAPSHOT.jar";
    private static final String staxJarPath = "modules/stax-api-1.0-2.jar";

    public ASMainOSGi(Logger logger, String ... args) {
        this.logger = logger;
        this.findBootstrapFile();
        this.glassfishDir = this.bootstrapFile.getParentFile().getParentFile();
        this.helper = new ASMainHelper(logger);
        this.context = new StartupContext(this.bootstrapFile, args);
        this.helper.parseAsEnv(this.glassfishDir);
        this.domainDir = this.helper.getDomainRoot(this.context);
        this.helper.verifyDomainRoot(this.domainDir);
        this.setFwDir();
    }

    protected abstract void setFwDir();

    public ASMainOSGi(String ... args) {
        this(Logger.getAnonymousLogger(), new String[0]);
    }

    protected abstract URL[] getFWJars() throws Exception;

    protected abstract void launchOSGiFW() throws Exception;

    public void run() {
        try {
            System.setProperty("org.jvnet.hk2.osgiadapter.contextrootdir", new File(this.glassfishDir, "modules").getAbsolutePath());
            this.setupLauncherClassLoader();
            this.launchOSGiFW();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setupLauncherClassLoader() throws Exception {
        ClassLoader commonCL = this.createCommonClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        Collections.addAll(urls, this.getFWJars());
        File moduleDir = this.context.getRootDirectory().getParentFile();
        this.helper.addPaths(moduleDir, this.additionalJarPrefixes, urls);
        this.launcherCL = this.helper.setupSharedCL(commonCL, urls, this.getSharedRepos());
        Thread.currentThread().setContextClassLoader(this.launcherCL);
    }

    private ClassLoader createCommonClassLoader() {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.helper.addPaths(new File(this.glassfishDir, "modules"), new String[]{"javax.javaee-"}, urls);
            if (System.getProperty("java.version").compareTo("1.6") < 0) {
                this.helper.addPaths(new File(this.glassfishDir, "modules"), new String[]{"stax-api"}, urls);
            }
            this.findDerbyClient(urls);
            File jdkToolsJar = this.helper.getJDKToolsJar();
            if (jdkToolsJar.exists()) {
                urls.add(jdkToolsJar.toURI().toURL());
            } else {
                this.logger.fine("JDK tools.jar does not exist at " + jdkToolsJar);
            }
            ClassLoader extCL = ClassLoader.getSystemClassLoader().getParent();
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), extCL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void findDerbyClient(List<URL> urls) throws MalformedURLException {
        ArrayList<URL> derbyUrls = new ArrayList<URL>();
        File derbyLib = new File(this.glassfishDir, "javadb/lib");
        if (!derbyLib.exists() && System.getProperty("java.version").compareTo("1.6") > 0) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.info("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        this.helper.addPaths(derbyLib, new String[]{"derbyclient"}, derbyUrls);
        if (derbyUrls.size() > 0) {
            urls.addAll(derbyUrls);
        }
    }

    private void findBootstrapFile() {
        String resourceName = this.getClass().getName().replace(".", "/") + ".class";
        URL resource = this.getClass().getClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new RuntimeException("Cannot get bootstrap path from " + resourceName + " class location, aborting");
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                JarURLConnection c = (JarURLConnection)resource.openConnection();
                URL jarFile = c.getJarFileURL();
                this.bootstrapFile = new File(jarFile.toURI());
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot open bootstrap jar file", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Incorrect bootstrap class URI", e);
            }
        } else {
            throw new RuntimeException("Don't support packaging " + resource + " , please contribute !");
        }
    }

    private List<Repository> getSharedRepos() {
        ArrayList<Repository> libs = new ArrayList<Repository>();
        File libDir = new File(this.glassfishDir, "lib");
        this.logger.fine("Path to library directory is " + libDir);
        if (libDir.exists()) {
            DirectoryBasedRepository libRepo = new DirectoryBasedRepository("lib", libDir, true);
            try {
                libRepo.initialize();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            libs.add((Repository)libRepo);
        } else {
            this.logger.info(libDir + " does not exist");
        }
        File domainlib = new File(this.domainDir, "lib");
        this.logger.fine("Path to domain library directory is " + domainlib);
        if (domainlib.exists()) {
            DirectoryBasedRepository domainLib = new DirectoryBasedRepository("domnainlib", domainlib, true);
            try {
                domainLib.initialize();
                libs.add((Repository)domainLib);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error while initializing domain lib repository", e);
            }
        } else {
            this.logger.info(domainlib + " does not exist");
        }
        return libs;
    }
}

