/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.arp.DefaultAsyncHandler;
import com.sun.grizzly.comet.CometAsyncFilter;
import com.sun.grizzly.cometd.standalone.CometdAdapter;
import com.sun.grizzly.http.AsyncFilter;
import com.sun.grizzly.http.AsyncHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.Main;
import com.sun.grizzly.standalone.StandaloneMainUtil;
import com.sun.grizzly.tcp.Adapter;
import java.util.logging.Level;

public class Cometd
extends StandaloneMainUtil {
    static int port = 8080;
    private String applicationLoc;

    public static void main(String[] args) throws Exception {
        Cometd main = new Cometd();
        main.start(args);
    }

    public SelectorThread createSelectorThread(String[] args) throws Exception {
        SelectorThread st = super.createSelectorThread(args);
        st.setEnableAsyncExecution(true);
        st.setBufferResponse(false);
        st.setFileCacheIsEnabled(false);
        st.setLargeFileCacheEnabled(false);
        DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
        asyncHandler.addAsyncFilter((AsyncFilter)new CometAsyncFilter());
        st.setAsyncHandler((AsyncHandler)asyncHandler);
        SelectorThread.logger().log(Level.INFO, "Enabling Grizzly Bayeux support.");
        return st;
    }

    public void printHelpAndExit() {
        System.err.println("Usage: " + Main.class.getCanonicalName() + " [options]");
        System.err.println();
        System.err.println("    -p, --port=port                  Runs Servlet on the specified port.");
        System.err.println("                                     Default: 8080");
        System.err.println("    -a, --apps=application path      The static resourde folder or jar or war location.");
        System.err.println("                                     Default: .");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }

    public boolean parseOptions(String[] args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printHelpAndExit();
                continue;
            }
            if ("-a".equals(arg)) {
                this.applicationLoc = args[++i];
                continue;
            }
            if (arg.startsWith("--application=")) {
                this.applicationLoc = arg.substring("--application=".length(), arg.length());
                continue;
            }
            if ("-p".equals(arg)) {
                this.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            String num = arg.substring("--port=".length(), arg.length());
            this.setPort(num);
        }
        if (this.applicationLoc == null) {
            System.err.println("Illegal War file.");
            this.printHelpAndExit();
        }
        return true;
    }

    public Adapter configureAdapter(SelectorThread st) {
        CometdAdapter adapter;
        String adapterClass = System.getProperty("com.sun.grizzly.adapterClass");
        if (adapterClass == null) {
            adapter = new CometdAdapter();
            adapter.setRootFolder(SelectorThread.getWebAppRootPath());
        } else {
            adapter = (Adapter)Cometd.loadClass(adapterClass);
        }
        return adapter;
    }

    public String parseApplicationLocation(String[] args) {
        return this.applicationLoc;
    }
}

