/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import com.sun.grizzly.util.ExpandJar;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class StandaloneMainUtil {
    public static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    public static final String ADAPTER = "com.sun.grizzly.adapterClass";
    private static int port = 8080;
    private long t1 = 0L;

    public void start(String[] args) throws Exception {
        SelectorThread st = this.createSelectorThread(args);
        this.startSelectorThread(st);
    }

    public SelectorThread createSelectorThread(String[] args) throws Exception {
        if (args.length == 0) {
            this.printHelpAndExit();
        }
        this.t1 = System.currentTimeMillis();
        this.parseOptions(args);
        String appliPath = this.parseApplicationLocation(args);
        if (new File("lib").exists()) {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createClassloader((File)new File("lib"), (ClassLoader)StandaloneMainUtil.class.getClassLoader()));
        }
        appliPath = this.appendWarContentToClassPath(appliPath);
        String selectorThreadClassname = System.getProperty(SELECTOR_THREAD);
        SelectorThread st = selectorThreadClassname != null ? (SelectorThread)StandaloneMainUtil.loadClass(selectorThreadClassname) : new SelectorThread(){

            public void listen() throws InstantiationException, IOException {
                super.listen();
                System.out.println("Server started in " + (System.currentTimeMillis() - StandaloneMainUtil.this.t1) + " milliseconds.");
            }
        };
        st.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        st.setPort(port);
        SelectorThread.setWebAppRootPath((String)appliPath);
        st.setAdapter(this.configureAdapter(st));
        return st;
    }

    public static Object loadClass(String clazzName) {
        Class<?> className = null;
        try {
            className = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public String appendWarContentToClassPath(String appliPath) throws MalformedURLException, IOException {
        String path;
        if (appliPath != null && appliPath.endsWith(".war") || appliPath.endsWith(".jar")) {
            File file = new File(appliPath);
            URL url = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            path = ExpandJar.expand((URL)url);
        } else {
            path = appliPath;
        }
        System.out.println("Running from: " + new File(path).getAbsolutePath());
        URL classesURL = new URL("file://" + path + "/WEB-INF/classes/");
        URL[] urls = new URL[]{classesURL};
        URLClassLoader urlClassloader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassloader);
        return path;
    }

    public void startSelectorThread(SelectorThread st) throws IOException, InstantiationException {
        st.setDisplayConfiguration(true);
        st.listen();
    }

    public void setPort(String num) {
        try {
            port = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal port number -- " + num);
            this.printHelpAndExit();
        }
    }

    public abstract void printHelpAndExit();

    public abstract boolean parseOptions(String[] var1);

    public abstract Adapter configureAdapter(SelectorThread var1);

    public abstract String parseApplicationLocation(String[] var1);
}

