/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.management.ObjectName;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanInterceptor;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.ConstrainedBeanListener;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBean
extends Dom
implements ConfigView {
    private volatile boolean writeLock = false;
    private final Map<Class, ConfigBeanInterceptor> optionalFeatures = new HashMap<Class, ConfigBeanInterceptor>();
    private volatile ObjectName objectName = null;
    private final Lock lock = new Lock(){

        public void lock() {
            throw new UnsupportedOperationException();
        }

        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        public synchronized boolean tryLock() {
            if (!ConfigBean.this.writeLock) {
                ConfigBean.this.writeLock = true;
                return true;
            }
            return false;
        }

        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        public synchronized void unlock() {
            ConfigBean.this.writeLock = false;
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    };

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectNameIn) {
        if (this.objectName != null) {
            throw new IllegalStateException();
        }
        this.objectName = objectNameIn;
    }

    public ConfigBean(Habitat habitat, DomDocument document, Dom parent, ConfigModel model, XMLStreamReader in) {
        super(habitat, document, parent, model, in);
        this.addInterceptor(new ConfigBeanInterceptor<ConstrainedBeanListener>(){
            List<VetoableChangeListener> listeners = new ArrayList<VetoableChangeListener>();

            @Override
            public ConstrainedBeanListener getConfiguration() {
                return new ConstrainedBeanListener(){

                    public void removeVetoableChangeListener(VetoableChangeListener listener) {
                        listeners.remove(listener);
                    }

                    public void addVetoableChangeListener(VetoableChangeListener listener) {
                        listeners.add(listener);
                    }
                };
            }

            @Override
            public void beforeChange(PropertyChangeEvent evt) throws PropertyVetoException {
                for (VetoableChangeListener listener : this.listeners) {
                    listener.vetoableChange(evt);
                }
            }

            @Override
            public void afterChange(PropertyChangeEvent evt, long timestamp) {
            }

            @Override
            public void readValue(ConfigBean source, String xmlName, Object Value) {
            }
        });
    }

    public <T> T getOptionalFeature(Class<T> featureType) {
        if (this.optionalFeatures.containsKey(featureType)) {
            return (T)this.optionalFeatures.get(featureType);
        }
        return null;
    }

    @Override
    protected void setter(ConfigModel.Property target, Object value) throws Exception {
        if (!this.writeLock) {
            throw new PropertyVetoException("Not part of a transaction !", null);
        }
        this._setter(target, value);
    }

    void _setter(ConfigModel.Property target, Object value) throws Exception {
        Object oldValue = super.getter(target, value.getClass());
        PropertyChangeEvent evt = new PropertyChangeEvent(this, target.xmlName(), oldValue, value);
        for (ConfigBeanInterceptor interceptor : this.optionalFeatures.values()) {
            interceptor.beforeChange(evt);
        }
        super.setter(target, value);
        for (ConfigBeanInterceptor interceptor : this.optionalFeatures.values()) {
            interceptor.afterChange(evt, System.currentTimeMillis());
        }
    }

    Object _getter(ConfigModel.Property target, Type t) {
        Object value = super.getter(target, t);
        for (ConfigBeanInterceptor interceptor : this.optionalFeatures.values()) {
            interceptor.readValue(this, target.xmlName(), value);
        }
        return value;
    }

    @Override
    protected Object getter(ConfigModel.Property target, Type t) {
        Object value = this._getter(target, t);
        if (value instanceof List) {
            ConfigBean myself = this;
            final List valueList = (List)value;
            return new AbstractList(){

                public int size() {
                    return valueList.size();
                }

                public Object get(int index) {
                    return valueList.get(index);
                }

                public boolean add(Object o) {
                    throw new IllegalStateException("Not part of a transaction !", null);
                }

                public Object set(int index, Object element) {
                    throw new IllegalStateException("Not part of a transaction !", null);
                }

                public Object remove(int index) {
                    throw new IllegalStateException("Not part of a transaction !", null);
                }
            };
        }
        return value;
    }

    public void addInterceptor(ConfigBeanInterceptor interceptor) {
        this.optionalFeatures.put(interceptor.getConfiguration().getClass(), interceptor);
    }

    @Override
    public ConfigBean getMasterView() {
        return this;
    }

    @Override
    public void setMasterView(ConfigView view) {
    }

    @Override
    public <T extends ConfigBeanProxy> T getProxy(Class<T> proxyType) {
        return (T)((ConfigBeanProxy)proxyType.cast(Proxy.newProxyInstance(proxyType.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)this)));
    }

    ConfigBean allocate(Class<?> type) {
        return new ConfigBean(this.habitat, this.document, this, this.document.buildModel(type), null);
    }

    <T extends ConfigBeanProxy> T allocateProxy(Class<T> type) {
        return this.allocate(type).createProxy(type);
    }

    public Lock getLock() {
        return this.lock;
    }
}

