/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.util;

import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SSHA {
    private static final String SSHA_TAG = "{SSHA}";
    private static StringManager sm = StringManager.getManager(SSHA.class);
    private static MessageDigest md = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compute(byte[] salt, byte[] password) throws IASSecurityException {
        byte[] buff = new byte[password.length + salt.length];
        System.arraycopy(password, 0, buff, 0, password.length);
        System.arraycopy(salt, 0, buff, password.length, salt.length);
        byte[] hash = null;
        Class<SSHA> clazz = SSHA.class;
        synchronized (SSHA.class) {
            if (md == null) {
                try {
                    md = MessageDigest.getInstance("SHA");
                }
                catch (Exception e) {
                    throw new IASSecurityException(e);
                }
            }
            assert (md != null);
            md.reset();
            hash = md.digest(buff);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            assert (hash.length == 20);
            return hash;
        }
    }

    public static byte[] compute(int saltBytes, byte[] password) throws IASSecurityException {
        SecureRandom rng = new SecureRandom();
        byte[] salt = new byte[saltBytes];
        rng.nextBytes(salt);
        return SSHA.compute(salt, password);
    }

    public static String encode(byte[] salt, byte[] hash) {
        assert (hash.length == 20);
        byte[] res = new byte[20 + salt.length];
        System.arraycopy(hash, 0, res, 0, 20);
        System.arraycopy(salt, 0, res, 20, salt.length);
        BASE64Encoder encoder = new BASE64Encoder();
        String encoded = encoder.encode(res);
        String out = SSHA_TAG + encoded;
        return out;
    }

    public static String computeAndEncode(byte[] salt, byte[] password) throws IASSecurityException {
        byte[] hash = SSHA.compute(salt, password);
        return SSHA.encode(salt, hash);
    }

    public static String computeAndEncode(int saltBytes, byte[] password) throws IASSecurityException {
        SecureRandom rng = new SecureRandom();
        byte[] salt = new byte[saltBytes];
        rng.nextBytes(salt);
        byte[] hash = SSHA.compute(salt, password);
        return SSHA.encode(salt, hash);
    }

    public static boolean verify(String encoded, byte[] password) throws IASSecurityException {
        byte[] hash = new byte[20];
        byte[] salt = SSHA.decode(encoded, hash);
        return SSHA.verify(salt, hash, password);
    }

    public static boolean verify(byte[] salt, byte[] hash, byte[] password) throws IASSecurityException {
        byte[] newHash = SSHA.compute(salt, password);
        return Arrays.equals(hash, newHash);
    }

    public static byte[] decode(String encoded, byte[] hashResult) throws IASSecurityException {
        assert (hashResult.length == 20);
        if (!encoded.startsWith(SSHA_TAG)) {
            String msg = sm.getString("ssha.badformat", (Object)encoded);
            throw new IASSecurityException(msg);
        }
        String ssha = encoded.substring(SSHA_TAG.length());
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] result = null;
        try {
            result = decoder.decodeBuffer(ssha);
        }
        catch (IOException e) {
            throw new IASSecurityException(e);
        }
        assert (result.length > 20);
        byte[] salt = new byte[result.length - 20];
        System.arraycopy(result, 0, hashResult, 0, 20);
        System.arraycopy(result, 20, salt, 0, result.length - 20);
        return salt;
    }
}

