/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Property;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Enumeration;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-file-users")
@Scoped(value=PerLookup.class)
@I18n(value="list.file.user")
public class ListFileUser
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListFileUser.class);
    @Param(name="authrealmname", optional=true)
    String authRealmName;
    @Param(optional=true)
    String target;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        SecurityService securityService = config.getSecurityService();
        if (this.authRealmName == null) {
            this.authRealmName = securityService.getDefaultRealm();
        }
        AuthRealm fileAuthRealm = null;
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            if (!authRealm.getName().equals(this.authRealmName)) continue;
            fileAuthRealm = authRealm;
        }
        if (fileAuthRealm == null) {
            report.setMessage(localStrings.getLocalString("list.file.user.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("list.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        FileRealm fr = null;
        try {
            fr = new FileRealm(keyFile);
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        try {
            Enumeration users = fr.getUserNames();
            while (users.hasMoreElements()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage((String)users.nextElement());
            }
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

